model Ex5_4
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real Length(final quantity="Length", final unit="km")=250"lenght of transmission line";
parameter Modelica.SIunits.Frequency f=50"line freqency";
parameter Real Sn(final quantity="Power", final unit="MVA")=25"power deivered by transmission line";
parameter Real pf=0.8"power factor";
parameter Real load_v(final quantity="ElectricPotential", final unit="kV")=132"receiving end voltage";
parameter Modelica.SIunits.Distance D=3"spacing between line conductors";
parameter Modelica.SIunits.Resistance r=0.11"conductor resistance/km";
parameter Real dia(final quantity="Diameter", final unit="cm")=1.6"effective diameter of conductors";
parameter Real w=314"a constant";
parameter Modelica.SIunits.Radius r_1=0.7788"self GMD of single conductor, already calculated in chapter2";
parameter Real radius(final quantity="Diameter", final unit="cm")=(dia/2)"radius of conductors"; 
parameter Real L(final quantity="Inductance",final unit="mH/km")=0.461*log10((D*100)/(r_1*radius))"inductance of line";
parameter Real fi=-acos(pf)"power factor angle, lagging so negative";
parameter Real C(final quantity="Capacitance",final unit="microF/km")=0.0242/(log10((D*100)/radius))"Line capacitance";
parameter Modelica.SIunits.Resistance R=r*Length"line resistance";
parameter Modelica.SIunits.Resistance X=2*pi*f*L*1e-3*Length"line reactance";
parameter Modelica.SIunits.ComplexImpedance Z=Complex(R,X)"line impedance";
parameter Modelica.SIunits.Impedance Z_abs = (Z.re ^ 2 + Z.im ^ 2) ^ 0.5"absolute value of line impedance";
  parameter Modelica.SIunits.Angle Z_arg = atan(Z.im / Z.re) * R2D "angle of line impedance";
  parameter Modelica.SIunits.ComplexAdmittance Y1=Complex(((w*C*1e-6*Length)*cos(pi/2)),((w*C*1e-6*Length)*sin(pi/2)))"line admittance";
  parameter Modelica.SIunits.Admittance Y1_abs = (Y1.re ^ 2 + Y1.im ^ 2) ^ 0.5"absolute value of line admittance";
  parameter Modelica.SIunits.Angle Y1_arg = atan(Y1.im / Y1.re) * R2D "angle of line admittance";
  parameter Modelica.SIunits.ComplexCurrent Ir=Complex((((Sn*1e3)/((3^0.5)*load_v))*cos(fi)),(((Sn*1e3)/((3^0.5)*load_v))*sin(fi)))"current through line";
  parameter Modelica.SIunits.Current Ir_abs = (Ir.re ^ 2 + Ir.im ^ 2) ^ 0.5"absolute value of line current";
  parameter  Modelica.SIunits.Angle Ir_arg = atan(Ir.im / Ir.re) * R2D "angle of line current";
  parameter Complex Vr_1=Complex(((load_v/(3^0.5))*cos(0)),((load_v/(3^0.5))*sin(0)))"receiving end voltage in kV/phase";
  parameter Real Vr_1_abs(final quantity="ElectricPotential", final unit="kV") = (Vr_1.re ^ 2 + Vr_1.im ^ 2) ^ 0.5"absolute value of receiving end voltage/phase";
  parameter Modelica.SIunits.Angle Vr_1_arg = atan(Vr_1.im / Vr_1.re) * R2D "angle of receiving end voltage/phase";
  parameter Complex Vs=((1+(0.5*Y1*Z))*Vr_1_abs)+(Z*1e-3*Ir)"sending end voltage in kV/phase";
  parameter Real Vs_abs(final quantity="ElectricPotential", final unit="kV") = (Vs.re ^ 2 + Vs.im ^ 2) ^ 0.5"absolute value of sending end voltage/phase";
  parameter Modelica.SIunits.Angle Vs_arg = atan(Vs.im / Vs.re) * R2D "angle of sending end voltage/phase";
  parameter Real Vs_line(final quantity="ElectricPotential", final unit="kV")=Vs_abs*(3^0.5)"line sending end voltage";
  parameter Complex A=(1+(0.5*Y1*Z))"parameter A";
  parameter Real A_abs = (A.re ^ 2 + A.im ^ 2) ^ 0.5"absolute value of parameter A";
  parameter Real Vro(final quantity="ElectricPotential", final unit="kV")=Vs_line/A_abs"line voltage with no load";
  parameter Real Vreg(unit="%")=((Vro-load_v)/load_v)*100"voltage regulation";
  //The answers may slightly vary due to rounding off values.
end Ex5_4;
