model Ex5_8
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
//case a
parameter Modelica.SIunits.ComplexImpedance X1=Complex(0,0.05)"impedance of a cable in pu";
parameter Real P_g1=20"maximum real power generated by generator G1 in pu"; 
parameter Real P_g2=P_g1"maximum real power generated by generator G2 in pu";
parameter Real P_s(final quantity="Power", final unit="MW")=5"real power at sending end"; 
parameter Real P_r(final quantity="Power", final unit="MW")=P_s"real power at receiving end";
parameter Real mod_V1=1"voltage of G1 in pu"; 
parameter Real mod_V2=1"voltage of G2 in pu";
parameter Modelica.SIunits.Angle theta=90"angle at which maximum real power can be transferred";
parameter Complex S_D1=Complex(15,5)"total demand at bus1 in pu";
parameter Complex S_D2=Complex(25,15)"total demand at bus2 in pu";
parameter Real delta1(unit="degree")=asin((P_s*X1.im)/(mod_V1*mod_V2))*R2D"torque angle in degree at which real power flows from bus1 to bus2";
parameter Complex V1_new=Complex((mod_V1*cos(delta1*D2R)),(mod_V1*sin(delta1*D2R)))"voltage at which real power flows from bus1 to bus2 in pu";
parameter Real V1_new_abs(unit="pu") = (V1_new.re ^ 2 + V1_new.im ^ 2) ^ 0.5"absolute value of voltage at which real power flows from bus1 to bus2";
parameter Real V1_new_arg(unit="degree") = atan(V1_new.im / V1_new.re) * R2D "angle of voltage at which real power flows from bus1 to bus2";
parameter Real Qs(unit="pu")= (((mod_V1)^2)/X1.im)-((mod_V1*mod_V2)/X1.im)*cos(delta1*D2R)"reactive power at sending end";
parameter Real Qr(unit="pu")=-Qs"reactive power at receiving end";
parameter Real QL(unit="pu")=Qs-Qr"reactive power loss in the cable";
parameter Complex C1=Complex(P_s,Qs)"a constant value";
parameter Complex C2=Complex(P_s,-Qs)"a constant value";
parameter Complex Lt_1=S_D1+C1"total load on station 1";
parameter Real pf_1=cos(atan(Lt_1.im/Lt_1.re))"power factor at station 1";
parameter Complex Lt_2=S_D2-C2"total load on station 2";
parameter Real pf_2=cos(atan(Lt_2.im/Lt_2.re))"power factor at station 2";
//case b
parameter Modelica.SIunits.ComplexImpedance X2=Complex(0.005,0.05)"impedance of a cable in pu"; 
parameter Modelica.SIunits.Impedance X2_abs = (X2.re ^ 2 + X2.im ^ 2) ^ 0.5"absolute value of impedance of a cable";
parameter Real X2_arg(unit="degree") = atan(X2.im / X2.re) * R2D "angle of impedance of a cable";
parameter Real P_g1b(unit="pu")=20"maximum real power generated by generator G1 in pu"; 
//solving equation 1 we get
parameter Real delta1_b_new(unit="degree")=(acos(cos(X2_arg*D2R)-X2_abs*P_s)*R2D)-X2_arg"torque angle in case-b";
//solving equation 2 we get
parameter Real Q_G1(unit="pu")=((1/X2_abs)*(sin(X2_arg*D2R)-sin((X2_arg+delta1_b_new)*D2R)))+P_s"maximum reactive power generated by generator G1";
//solving equation 4 we get
parameter Real Q_G2(unit="pu")=S_D1.re-((1/X2_abs)*(-sin(X2_arg*D2R)+sin((X2_arg-delta1_b_new)*D2R)))"maximum reactive power generated by generator G2";
//solving equation 3 we get
parameter Real P_G2(unit="pu")=S_D2.re-((1/X2_abs)*(-cos(X2_arg*D2R)+cos((X2_arg-delta1_b_new)*D2R)))"maximum real power generated by generator G1";
 //The answers may slightly vary due to rounding off values. 
end Ex5_8;
