model Ex6_12
constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real V3(unit = "pu")=1.04"voltage at bus3";
parameter Real V3_prime(unit = "pu")=1"modified voltage at bus3";
//case 1:
parameter Real a=V3_prime/V3"tap ratio of regulating transformer";
//here we are using some elements of Y_bus from Ex6_3 as follows
parameter Complex Y33_old=Complex(3.666,-11)" diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y34_old=Complex(-2,6)" off-diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y43_old=Y34_old"off-diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y44_old=Complex(3,-9)" diagonal element of Y_bus from Ex6_3 ";
parameter Complex y34=Complex(2,-6)" off-diagonal element of Y_bus from Ex6_3";
parameter Complex Y_bus_33=Y33_old-y34+(a^2)*y34"modified diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y_bus_34=Y34_old+y34-a*y34"modified diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y_bus_43=Y43_old+y34-a*y34"modified diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y_bus_44=Y44_old"modified diagonal element of Y_bus from Ex6_3 ";
parameter Complex [2,2]Y_bus={{Y_bus_33,Y_bus_34},{Y_bus_43,Y_bus_44}}"modified complex bus admittances in matrix form";
//case 2:
parameter Complex a2=Complex(1*cos(3*D2R),1*(-sin(3*D2R)))"tap ratio of regulating transformer";
parameter Complex a2c=Complex(1*cos(3*D2R),1*sin(3*D2R))"complex conjugate of tap ratio of regulating transformer";
parameter Real a2_abs = (a2.re ^ 2 + a2.im ^ 2) ^ 0.5"absolute value of complex conjugate of tap ratio of regulating transformer";
parameter Complex Y_bus_2_33=Y33_old-y34+(a2_abs^2)*y34"modified diagonal element of Y_bus  from Ex6_3";
parameter Complex Y_bus_2_34=Y34_old+y34-a2c*y34"modified diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y_bus_2_43=Y43_old+y34-a2*y34"modified diagonal element of Y_bus from Ex6_3 ";
parameter Complex Y_bus_2_44=Y44_old"modified diagonal element of Y_bus  from Ex6_3";
parameter Complex [2,2]Y_bus_2={{Y_bus_2_33,Y_bus_2_34},{Y_bus_2_43,Y_bus_2_44}}"modified complex bus admittances in matrix form";
//The answers may slightly vary due to rounding off values.
end Ex6_12;
