model Ex6_14
constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Complex Zl=Complex(0,0.25)"each line impedance in pu";
parameter Complex Yl=1/Zl"series line admittance in pu";
//elements of Y_bus are:
parameter Complex Y11=2*Yl"diagonal element of Y bus in pu";
parameter Complex Y12=-Yl"off diagonal element of Y bus in pu";
parameter Complex Y13=-Yl"off diagonal element of Y bus in pu";
parameter Complex Y21=Y12"off diagonal element of Y bus in pu";
parameter Complex Y22=Y11"diagonal element of Y bus in pu";
parameter Complex Y23=-Yl"off diagonal element of Y bus in pu";
parameter Complex Y31=Y13"off diagonal element of Y bus in pu";
parameter Complex Y32=Y23"off diagonal element of Y bus in pu";
parameter Complex Y33=Y11"diagonal element of Y bus in pu";
parameter Complex[3, 3] Y_bus = {{Y11, Y12,Y13}, {Y21, Y22,Y23},{Y31,Y32,Y33}}"complex bus admittances in matrix form";
//substituting different values in equation (iii) and (iv) and equating the imaginary part of equation (v) we get a equation of V2, applying Shridhar acharya formula we can solve it as follows
parameter Real a=8; 
parameter Real b=-7.6;
parameter Real c=0.4;
parameter Real V2_1(unit = "pu")=(-b+(b^2-4*a*c)^0.5)/(2*a)"bus2 voltage, allowing +ve sign";
parameter Real V2_2(unit = "pu")=(-b-(b^2-4*a*c)^0.5)/(2*a)"bus2 voltage, allowing -ve sign";
//equating real parts of equations (v) and (vi) and using Crammer's rule we get the values of delta2 and delta3 as follows
parameter Real delta2(unit = "radian")=((-0.5*6.8184)+(0.5*3.2184))/((6.7944*6.8184)-(3.2184*3.2184))"angle of bus 2";
parameter Real delta3(unit = "radian")=((0.5*6.7944)+(-0.5*3.2184))/((6.7944*6.8184)-(3.2184*3.2184))"angle of bus 3";
parameter Real delta2_new(unit = "degree")=delta2*R2D"angle of bus 2";
parameter Real delta3_new(unit = "degree")=delta3*R2D"angle of bus 3";
parameter Real V2(unit = "pu")=V2_1"bus2 voltage";
//The answers may slightly vary due to rounding off values. 
end Ex6_14;
