model Ex6_15
OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1 annotation(
    Placement(visible = true, transformation(origin = {-58, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1.05, angle_0 = -3, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-104, 30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 0.95, angle_0 = 2, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {114, 30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {10, -68}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.1) annotation(
    Placement(visible = true, transformation(origin = {36, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-104, -12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.1) annotation(
    Placement(visible = true, transformation(origin = {114, -22}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-174, 72}, extent = {{-20, -18}, {20, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21 annotation(
    Placement(visible = true, transformation(origin = {-105, 65}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22 annotation(
    Placement(visible = true, transformation(origin = {10, -82}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order23 annotation(
    Placement(visible = true, transformation(origin = {115, 65}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_0 = 1.05, angle_0 = -3, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-10, 32}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);   // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  //case a
  parameter Complex a = Complex(1.049, -0.046) "complex turns ratio of transformer";
  parameter Real a_abs = (a.re ^ 2 + a.im ^ 2) ^ 0.5"absolute value of complex turns ratio of transformer";
  parameter Real a_arg(unit = "degree") = atan(a.im / a.re) * R2D "angle of complex turns ratio of transformer";
  parameter Complex a_c = Complex(1.049, 0.046) "complex conjugate of complex turns ratio of transformer";
  parameter Complex y = Complex(0, -10) "line admittance in pu";
  parameter Real y_abs(unit = "pu") = (y.re ^ 2 + y.im ^ 2) ^ 0.5"absolute value of line admittance";
  //using equations 6.9 and 6.101 we get the elements of Y_bus as follows
  parameter Complex Y11 = Complex(0, -20)"diagonal element of Y bus in pu";
  parameter Complex Y12 = Complex(0, 10)"off diagonal element of Y bus in pu";
  parameter Complex Y13 = Complex(0, 10)"off diagonal element of Y bus in pu";
  parameter Complex Y21 = Complex(0, 10)"off diagonal element of Y bus in pu";
  parameter Complex Y22 = y + a_abs ^ 2 * y"diagonal element of Y bus in pu";
  parameter Complex Y23 = -a_c * y"off diagonal element of Y bus in pu";
  parameter Complex Y31 = Complex(0, 10)"off diagonal element of Y bus in pu";
  parameter Complex Y32 = -a * y"off diagonal element of Y bus in pu";
  parameter Complex Y33 = Complex(0, -20)"diagonal element of Y bus in pu";
  parameter Complex[3, 3] Y_bus = {{Y11, Y12, Y13}, {Y21, Y22, Y23}, {Y31, Y32, Y33}}"complex bus admittances in matrix form";
  //case b
  //case-b.1
  parameter Complex a1 = Complex(1 * cos(0), 1 * sin(0))"complex turns ratio of transformer";
  parameter Real a1_abs = (a1.re ^ 2 + a1.im ^ 2) ^ 0.5"absolute value of complex turns ratio of transformer";
  parameter Real a1_arg(unit = "degree") = atan(a1.im / a1.re) * R2D "angle of complex turns ratio of transformer";
  parameter Real theta(unit = "degree") = 90 "value of theta";
  parameter Real P23(unit = "pu") = y_abs * bus2.V_0 * (a_abs * bus2.V_0 * cos(theta * D2R) - bus3.V_0 * cos(theta * D2R + bus3.angle_0 * D2R - bus2.angle_0 * D2R - a1_arg * D2R)) "real power flow from bus2 to bus3";
  parameter Real Q23(unit = "pu") = -a1_abs * y_abs * bus2.V_0 * (a1_abs * bus2.V_0 * sin(pi / 2) - bus3.V_0 * sin(pi / 2 + bus3.angle_0 * D2R - bus2.angle_0 * D2R - a1_arg * D2R)) "reactive power flow from bus2 to bus3";
  //case-b.2
  parameter Complex a2 = Complex(1 * cos(-2.5 * D2R), 1 * sin(-2.5 * D2R))"complex turns ratio of transformer";
  parameter Real a2_abs = (a2.re ^ 2 + a2.im ^ 2) ^ 0.5"absolute value of complex turns ratio of transformer";
  parameter Real a2_arg(unit = "degree") = atan(a2.im / a2.re) * R2D "angle of complex turns ratio of transformer";
  parameter Real P23_b(unit = "pu") = y_abs * bus2.V_0 * (a2_abs * bus2.V_0 * cos(theta * D2R) - bus3.V_0 * cos(theta * D2R + bus3.angle_0 * D2R - bus2.angle_0 * D2R - a2_arg * D2R)) "real power flow from bus2 to bus3";
  parameter Real Q23_b(unit = "pu") = -a2_abs * y_abs * bus2.V_0 * (a2_abs * bus2.V_0 * sin(pi / 2) - bus3.V_0 * sin(pi / 2 + bus3.angle_0 * D2R - bus2.angle_0 * D2R - a2_arg * D2R)) "reactive power flow from bus2 to bus3";
  parameter Real delp_23(unit = "pu") = P23_b - P23 "increase in real power flow";
  parameter Real delQ_23(unit = "pu") = Q23_b - Q23 "increase in reactive power flow";
  //case c
  parameter Complex a3 = Complex(1.05 * cos(0), 1.05 * sin(0))"complex turns ratio of transformer";
  parameter Real a3_abs = (a3.re ^ 2 + a3.im ^ 2) ^ 0.5"absolute value of complex turns ratio of transformer";
  parameter Real a3_arg(unit = "degree") = atan(a3.im / a3.re) * R2D "angle of complex turns ratio of transformer";
  parameter Real P23_c(unit = "pu") = y_abs * bus2.V_0 ^ 2 * (a3_abs * bus2.V_0 ^ 2 * cos(theta * D2R) - bus3.V_0 * cos(theta * D2R + bus3.angle_0 * D2R - bus2.angle_0 * D2R - a3_arg * D2R)) "real power flow from bus2 to bus3";
  parameter Real Q23_c(unit = "pu") = (-a3_abs * y_abs * bus2.V_0) * (a3_abs * bus2.V_0 * sin(pi / 2) - bus3.V_0 * sin(pi / 2 + bus3.angle_0 * D2R - bus2.angle_0 * D2R - a3_arg * D2R)) "reactive power flow from bus2 to bus3";
  parameter Real delp_23_c(unit = "pu") = P23_c - P23 "increase in real power flow";
  parameter Real delQ_23_c(unit = "pu") = Q23_c - Q23_b "increase in reactive power flow";
    equation
  connect(twoWindingTransformer1.n, bus4.p) annotation(
    Line(points = {{-47, 30}, {-10, 30}, {-10, 32}}, color = {0, 0, 255}));
  connect(bus2.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-104, 30}, {-69, 30}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus4.p) annotation(
    Line(points = {{28, 30}, {-10, 30}, {-10, 32}, {-10, 32}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine1.n) annotation(
    Line(points = {{114, 30}, {45, 30}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.p) annotation(
    Line(points = {{114, 30}, {114, -13}}, color = {0, 0, 255}));
  connect(order23.p, bus3.p) annotation(
    Line(points = {{115, 58}, {115, 30}, {114, 30}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine3.n) annotation(
    Line(points = {{10, -68}, {10, -60}, {114, -60}, {114, -31}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine2.p) annotation(
    Line(points = {{-104, 30}, {-104, -3}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.n) annotation(
    Line(points = {{10, -68}, {6, -68}, {6, -60}, {-104, -60}, {-104, -21}}, color = {0, 0, 255}));
  connect(order21.p, bus2.p) annotation(
    Line(points = {{-105, 58}, {-105, 30}, {-104, 30}}, color = {0, 0, 255}));
  connect(order23.pm0, order23.pm) annotation(
    Line(points = {{107.3, 70.6}, {103.3, 70.6}, {103.3, 80.6}, {107.3, 80.6}, {107.3, 80.6}, {111.3, 80.6}, {111.3, 74.6}, {111.3, 74.6}}, color = {0, 0, 127}));
  connect(order23.vf, order23.vf0) annotation(
    Line(points = {{118.5, 73.4}, {118.5, 73.4}, {118.5, 79.4}, {126.5, 79.4}, {126.5, 69.4}, {122.5, 69.4}, {122.5, 69.4}}, color = {0, 0, 127}));
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-108.5, 73.4}, {-108.5, 73.4}, {-108.5, 79.4}, {-116.5, 79.4}, {-116.5, 69.4}, {-112.5, 69.4}, {-112.5, 69.4}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-101.5, 73.4}, {-101.5, 73.4}, {-101.5, 79.4}, {-93.5, 79.4}, {-93.5, 69.4}, {-97.5, 69.4}, {-97.5, 69.4}}, color = {0, 0, 127}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{14, -90}, {14, -90}, {14, -92}, {20, -92}, {20, -86}, {16, -86}, {16, -86}}, color = {0, 0, 127}));
  connect(order22.vf0, order22.vf) annotation(
    Line(points = {{4, -86}, {0, -86}, {0, -92}, {8, -92}, {8, -90}, {6, -90}}, color = {0, 0, 127}));
  connect(order22.p, bus1.p) annotation(
    Line(points = {{10, -76}, {10, -76}, {10, -68}, {10, -68}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values.
annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex6_15;
