model Ex6_8
OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1.04, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-64, 52}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(P_0 = 0.5, Q_0 = -0.2, V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {44,52}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3(P_0 = -1, Q_0 = 0.5, V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-64, -50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4(P_0 = 0.3, Q_0 = -0.1, V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {44, -50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1 annotation(
    Placement(visible = true, transformation(origin = {-12, 58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2 annotation(
    Placement(visible = true, transformation(origin = {-12, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3 annotation(
    Placement(visible = true, transformation(origin = {-64, 6}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4 annotation(
    Placement(visible = true, transformation(origin = {44, 6}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine5 annotation(
    Placement(visible = true, transformation(origin = {-12, 6}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-161, 77}, extent = {{-15, -15}, {15, 15}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21 annotation(
    Placement(visible = true, transformation(origin = {-67, 77}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22 annotation(
    Placement(visible = true, transformation(origin = {-67, -77}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order23 annotation(
    Placement(visible = true, transformation(origin = {47, 79}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order24 annotation(
    Placement(visible = true, transformation(origin = {49, -77}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {-88, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2 annotation(
    Placement(visible = true, transformation(origin = {76, 84}, extent = {{-6, -6}, {6, 6}}, rotation = 180)));
parameter Real P2(unit = "pu")=0.5"real power of bus 2";
parameter Real P3(unit = "pu")=-1"real power of bus 3";
parameter Real P4(unit = "pu")=0.3"real power of bus 4";
parameter Real Q2(unit = "pu")=-0.2"reactive power of bus 2";
parameter Real Q3(unit = "pu")=0.5"reactive power of bus 3";
parameter Real Q4(unit = "pu")=-0.1"reactive power of bus 4";
parameter Complex Power2=Complex(P2,-Q2)"Aparant power of bus2 in pu ";
parameter Complex Power3=Complex(P3,-Q3)"Aparant power of bus3 in pu  ";
parameter Complex Power4=Complex(P4,-Q4)"Aparant power of bus4 in pu  ";
  //From example 6.3 we use the Y_bus_new as follows:
  //The components of this Y_bus are
parameter Complex Y11 = Complex(3, -9)"diagonal elements of Y_bus, they are self admittance";
parameter Complex Y12=Complex(-2,6)"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y13=Complex(-1,3)"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y14=Complex(0,0)"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y21=Y12"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y22=Complex(3.666,-11)"diagonal elements of Y_bus, they are self admittance";
parameter Complex Y23=Complex(-0.666,2)"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y24=Y13"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y31=Y13"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y32=Y23"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y33=Y22"diagonal elements of Y_bus, they are self admittance";
parameter Complex Y34=Y12"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y41=Y14"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y42=Y13"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y43=Y12"off-diagonal elements of y_bus, they are transfer admittance";
parameter Complex Y44=Y11"diagonal elements of Y_bus, they are self admittance";
Complex [4,4]Y_bus={{Y11,Y12,Y13,Y14},{Y21,Y22,Y23,Y24},{Y31,Y32,Y33,Y34},{Y41,Y42,Y43,Y44}}"complex bus admittances in matrix form";
parameter Complex V2_1=(1/Y22)*((Power2/1)-(Y21*1.04)-(Y23*1)-(Y24*1))"bus voltage at the end of 1st iteration in pu";
parameter Complex V3_1=(1/Y33)*((Power3/1)-(Y31*1.04)-(Y32*V2_1)-(Y34*1))"bus voltage at the end of 1st iteration in pu";
parameter Complex V4_1=(1/Y44)*((Power4/1)-(Y41*V2_1)-(Y23*V2_1)-(Y43*V3_1))"bus voltage at the end of 1st iteration in pu";
  equation
  connect(bus3.p, voltDependant1.p) annotation(
    Line(points = {{-64, -50}, {-72, -50}, {-72, -66}, {-88, -66}, {-88, -74}, {-88, -74}}, color = {0, 0, 255}));
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{44, 52}, {52, 52}, {52, 62}, {76, 62}, {76, 78}, {76, 78}}, color = {0, 0, 255}));
  connect(order24.pm, order24.pm0) annotation(
    Line(points = {{52, -86}, {52, -86}, {52, -90}, {60, -90}, {60, -82}, {56, -82}, {56, -82}}, color = {0, 0, 127}));
  connect(order24.vf, order24.vf0) annotation(
    Line(points = {{46, -86}, {46, -86}, {46, -90}, {38, -90}, {38, -82}, {42, -82}, {42, -82}}, color = {0, 0, 127}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{-64, -86}, {-64, -86}, {-64, -90}, {-56, -90}, {-56, -82}, {-60, -82}, {-60, -82}}, color = {0, 0, 127}));
  connect(order22.vf, order22.vf0) annotation(
    Line(points = {{-70, -86}, {-70, -86}, {-70, -90}, {-78, -90}, {-78, -82}, {-74, -82}, {-74, -82}}, color = {0, 0, 127}));
  connect(order23.vf0, order23.vf) annotation(
    Line(points = {{54, 84}, {60, 84}, {60, 94}, {50, 94}, {50, 88}, {50, 88}}, color = {0, 0, 127}));
  connect(order23.pm, order23.pm0) annotation(
    Line(points = {{44, 88}, {44, 88}, {44, 94}, {34, 94}, {34, 84}, {40, 84}, {40, 84}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-64, 86}, {-64, 86}, {-64, 92}, {-54, 92}, {-54, 82}, {-60, 82}, {-60, 82}}, color = {0, 0, 127}));
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-70, 86}, {-70, 86}, {-70, 92}, {-80, 92}, {-80, 82}, {-74, 82}, {-74, 82}}, color = {0, 0, 127}));
  connect(order24.p, bus4.p) annotation(
    Line(points = {{49, -70}, {48, -70}, {48, -50}, {44, -50}}, color = {0, 0, 255}));
  connect(order22.p, bus3.p) annotation(
    Line(points = {{-67, -70}, {-68, -70}, {-68, -50}, {-64, -50}}, color = {0, 0, 255}));
  connect(order23.p, bus2.p) annotation(
    Line(points = {{47, 72}, {48, 72}, {48, 52}, {44, 52}}, color = {0, 0, 255}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-67, 70}, {-68, 70}, {-68, 52}, {-64, 52}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine3.p) annotation(
    Line(points = {{-64, 52}, {-64, 15}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus3.p) annotation(
    Line(points = {{-64, -3}, {-64, -50}}, color = {0, 0, 255}));
  connect(pwLine4.n, bus4.p) annotation(
    Line(points = {{44, -3}, {44, -50}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine4.p) annotation(
    Line(points = {{44, 52}, {44, 15}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{-3, 58}, {44, 58}, {44, 52}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus1.p) annotation(
    Line(points = {{-21, 58}, {-64, 58}, {-64, 52}}, color = {0, 0, 255}));
  connect(pwLine5.n, bus3.p) annotation(
    Line(points = {{-12, -3}, {-12, -30}, {-60, -30}, {-60, -50}, {-64, -50}}, color = {0, 0, 255}));
  connect(pwLine5.p, bus2.p) annotation(
    Line(points = {{-12, 15}, {-12, 34}, {40, 34}, {40, 52}, {44, 52}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus4.p) annotation(
    Line(points = {{-2, -58}, {44, -58}, {44, -50}, {44, -50}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.p) annotation(
    Line(points = {{-64, -50}, {-64, -58}, {-21, -58}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values.
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex6_8;
