model Ex9_2
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 25, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-4, 70}, extent = {{-24, -18}, {24, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator(D = 0, M = 8, Sn = S_n, V_0 = 1, V_b = 11, Vn = 11, angle_0 = 0, ra = 0, x1d = X2) annotation(
    Placement(visible = true, transformation(origin = {-168, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor1(D = 0, M = 8, Sn = 25, V_0 = 1, V_b = 6.6, Vn = 6.6, angle_0 = 0, ra = 0, x1d = X1) annotation(
    Placement(visible = true, transformation(origin = {130, 40}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor2(D = 0, M = 8, Sn = 25, V_0 = 1, V_b = 6.6, Vn = 6.6, angle_0 = 0, ra = 0, x1d = X1) annotation(
    Placement(visible = true, transformation(origin = {130, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor3(D = 0, M = 8, Sn = 25, V_0 = 1, V_b = 6.6, Vn = 6.6, angle_0 = 0, ra = 0, x1d = X1) annotation(
    Placement(visible = true, transformation(origin = {130, -40}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 10, t2 = 50) annotation(
    Placement(visible = true, transformation(origin = {134, -76}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {86, 40}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {86, 0}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3 annotation(
    Placement(visible = true, transformation(origin = {86, -40}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_b = 6.6, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {54, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {-138, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4 annotation(
    Placement(visible = true, transformation(origin = {-120, 0}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = X3) annotation(
    Placement(visible = true, transformation(origin = {-94, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = X4) annotation(
    Placement(visible = true, transformation(origin = {-40, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker5 annotation(
    Placement(visible = true, transformation(origin = {-12, 0}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = X5) annotation(
    Placement(visible = true, transformation(origin = {16, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker6 annotation(
    Placement(visible = true, transformation(origin = {40, 0}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {-68, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);   // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Real S_n(final quantity="Power", final unit="MVA") = 25 "system base";
  parameter Real S_n1(final quantity="Power", final unit="MVA") = 5 "system base of each motor";
  parameter Real X1(unit = "pu") = 1.25"reactances of motors";
  parameter Complex Xm = Complex(0, X1) "reactances of motors in complex form in pu";
  parameter Real Vb_c(final quantity="ElectricPotential", final unit="kV") = 6.6 "base voltage in circuit breaker b";
  parameter Real X2(unit = "pu") = 0.2"reactances of generator";
  parameter Complex Xg = Complex(0, X2) "reactances of generator in complex form in pu";
  parameter Real X3(unit = "pu") = 0.1"reactances of transformer1";
  parameter Complex XT1 = Complex(0, X3) "reactances of transformer1 in complex form in pu";
  parameter Real X4(unit = "pu") = 0.15"reactances of line";
  parameter Complex Xl = Complex(0, X4) "reactances of line in complex form  in pu";
  parameter Real X5(unit = "pu") = 0.1"reactances of transformer2";
  parameter Complex XT2 = Complex(0, X5) "reactances of transformer2 in complex form in pu";
  parameter Real X6(unit = "pu") = 0.30"subtransient reactances of motors";
  parameter Complex Xd = Complex(0, X6) "subtransient reactances of motors in complex form in pu";
  parameter Complex X_total = Xg + XT1 + Xl + XT2"total reactance in pu";
  // case a
  parameter Complex I_sc = 3 * (1 / Xm) + 1 / X_total"current through the circuit in pu";
  parameter Modelica.SIunits.Current I_bc = S_n * 1e3 / (3 ^ 0.5 * Vb_c) "base current in circuit breaker b";
  parameter Modelica.SIunits.Current I_sc1 = -I_sc.im * I_bc "subtransient current in the fault";
  //case b
  parameter Complex I_sc_b = 2 * (1 / Xm) + 1 / X_total"current through circuit breaker B";
  parameter Modelica.SIunits.Current I_sc_b1 = -I_sc_b.im * I_bc "subtransient current in the breaker B";
  //case c
  parameter Modelica.SIunits.Current I_sc_c = I_sc_b1 * 1.6 "momentary current through breaker B";
  //case d
  parameter Complex Xd1 = Xd * (S_n / S_n1) "motor transient reactance in pu";
  parameter Complex Xd2 = 2 * (1 / Xd1) + 1 / X_total "current to be interrupted by breaker in pu";
  parameter Modelica.SIunits.Current I = 1.1 * (-Xd2.im) * I_bc "current to be interrupted by breaker B in five cycles";
  equation
  connect(pwLine1.p, bus3.p) annotation(
    Line(points = {{-49, 0}, {-68, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus3.p) annotation(
    Line(points = {{-82, 0}, {-68, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, breaker5.s) annotation(
    Line(points = {{-31, 0}, {-17, 0}}, color = {0, 0, 255}));
  connect(breaker5.r, twoWindingTransformer2.p) annotation(
    Line(points = {{-7, 0}, {5, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, breaker6.s) annotation(
    Line(points = {{27, 0}, {35, 0}}, color = {0, 0, 255}));
  connect(breaker6.r, bus1.p) annotation(
    Line(points = {{45, 0}, {54, 0}}, color = {0, 0, 255}));
  connect(bus1.p, breaker2.s) annotation(
    Line(points = {{54, 0}, {82, 0}}, color = {0, 0, 255}));
  connect(bus1.p, breaker1.s) annotation(
    Line(points = {{54, 0}, {54, 6}, {64, 6}, {64, 40}, {82, 40}}, color = {0, 0, 255}));
  connect(bus1.p, breaker3.s) annotation(
    Line(points = {{54, 0}, {54, -6}, {64, -6}, {64, -40}, {82, -40}}, color = {0, 0, 255}));
  connect(breaker4.r, twoWindingTransformer1.p) annotation(
    Line(points = {{-115, 0}, {-105, 0}}, color = {0, 0, 255}));
  connect(bus2.p, breaker4.s) annotation(
    Line(points = {{-138, 0}, {-125, 0}}, color = {0, 0, 255}));
  connect(generator.p, bus2.p) annotation(
    Line(points = {{-158, 0}, {-138, 0}}, color = {0, 0, 255}));
  connect(generator.vf0, generator.vf) annotation(
    Line(points = {{-176, 11}, {-176, 11}, {-176, 17}, {-190, 17}, {-190, 5}, {-180, 5}, {-180, 5}}, color = {0, 0, 127}));
  connect(generator.pm, generator.pm0) annotation(
    Line(points = {{-180, -5}, {-188, -5}, {-188, -17}, {-176, -17}, {-176, -11}, {-176, -11}}, color = {0, 0, 127}));
  connect(breaker3.r, pwFault1.p) annotation(
    Line(points = {{92, -40}, {100, -40}, {100, -76}, {128, -76}, {128, -76}}, color = {0, 0, 255}));
  connect(motor3.vf, motor3.vf0) annotation(
    Line(points = {{142, -35}, {152, -35}, {152, -25}, {138, -25}, {138, -29}, {138, -29}}, color = {0, 0, 127}));
  connect(motor3.pm, motor3.pm0) annotation(
    Line(points = {{142, -45}, {152, -45}, {152, -55}, {138, -55}, {138, -51}, {138, -51}}, color = {0, 0, 127}));
  connect(breaker3.r, motor3.p) annotation(
    Line(points = {{91, -40}, {120, -40}}, color = {0, 0, 255}));
  connect(motor2.vf, motor2.vf0) annotation(
    Line(points = {{142, 6}, {152, 6}, {152, 16}, {138, 16}, {138, 12}, {138, 12}}, color = {0, 0, 127}));
  connect(motor1.vf, motor1.vf0) annotation(
    Line(points = {{142, 46}, {152, 46}, {152, 58}, {142, 58}, {142, 58}, {138, 58}, {138, 52}, {138, 52}}, color = {0, 0, 127}));
  connect(breaker2.r, motor2.p) annotation(
    Line(points = {{91, 0}, {120, 0}}, color = {0, 0, 255}));
  connect(breaker1.r, motor1.p) annotation(
    Line(points = {{91, 40}, {120, 40}}, color = {0, 0, 255}));
  connect(motor1.pm, motor1.pm0) annotation(
    Line(points = {{142, 35}, {152, 35}, {152, 23}, {138, 23}, {138, 31}, {138, 31}, {138, 29}}, color = {0, 0, 127}));
  connect(motor2.pm, motor2.pm0) annotation(
    Line(points = {{142, -5}, {152, -5}, {152, -15}, {138, -15}, {138, -11}, {138, -11}}, color = {0, 0, 127}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex9_2;
