model Ex9_5
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-162, 73}, extent = {{-26, -19}, {26, 19}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, S_b = 100, Sn = 100, V_b = 11, Vn = 11, ra = 0, x1d = XG) annotation(
    Placement(visible = true, transformation(origin = {-71, 75}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 100, Vn = 110, r = 0, x = XT) annotation(
    Placement(visible = true, transformation(origin = {-72, 42}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-72, 20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {58, 18}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {-72, -32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {62, -34}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = X1) annotation(
    Placement(visible = true, transformation(origin = {-4, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = X3) annotation(
    Placement(visible = true, transformation(origin = {-4, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = X4) annotation(
    Placement(visible = true, transformation(origin = {-72, -2}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = X5) annotation(
    Placement(visible = true, transformation(origin = {62, -2}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0, G = 0, R = 0, X = X2) annotation(
    Placement(visible = true, transformation(origin = {-2, -4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(Sn = 100, V_b = 110, r = 0, x = XT) annotation(
    Placement(visible = true, transformation(origin = {66, -54}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22(D = 0, M = 8, S_b = S_n, Sn = 100, V_b = 11, Vn = 11, ra = 0, x1d = XG) annotation(
    Placement(visible = true, transformation(origin = {67, -81}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 5, t2 = 50) annotation(
    Placement(visible = true, transformation(origin = {-72, -80}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {58, 68}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-72, -54}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  parameter Real XG(unit = "pu") = 0.1"reactance of generator";
  parameter Real XT(unit = "pu") = 0.05"reactance of transformer";
  parameter Real X1(unit = "pu") = 0.15"reactance of power line1";
  parameter Real X2(unit = "pu") = 0.2"reactance of power line5";
  parameter Real X3(unit = "pu") = 0.15"reactance of power line2";
  parameter Real X4(unit = "pu") = 0.1"reactance of power line3";
  parameter Real X5(unit = "pu") = 0.1"reactance of power line4";
  parameter Real S_n(final quantity="Power", final unit="MVA") = 100 "system base";
  parameter Real modV(unit = "pu") = 1"prefault voltage";
  parameter Real X(unit = "pu") = XG + XT"total reactance of generator and transformer";
  parameter Real X6(unit = "pu") = X2 * (X + X4) / (X2 + X + X4)"reactance calculated from diagram";
  parameter Real X7(unit = "pu") = X6 * X5 / (X6 + X5 + X3) + X"reactance calculated from diagram";
  parameter Real X8(unit = "pu") = X6 * X3 / (X6 + X5 + X3) + X"reactance calculated from diagram";
  parameter Real X9(unit = "pu") = X5 * X3 / (X6 + X5 + X3)"reactance calculated from diagram";
  parameter Real X10(unit = "pu") = X7 * X8 / (X7 + X8) + X9"reactance calculated from diagram";
  parameter Complex Z1 = Complex(0, X10) "impedance,obtained after simplying the circuit in pu";
  parameter Complex Z2 = Complex(0, X8) "impedance,obtained after simplying the circuit in pu";
  parameter Complex Z3 = Complex(0, X7) "impedance,obtained after simplying the circuit in pu";
  parameter Complex Z4 = Complex(0, X8 + X7) "impedance,obtained after simplying the circuit in pu";
  parameter Complex Z5 = Complex(0, X) "impedance,obtained after simplying the circuit in pu";
  parameter Complex Z6 = Complex(0, X4) "impedance,obtained after simplying the circuit in pu";
  parameter Complex If = modV / Z1 "fault current in pu";
  parameter Complex I1 = If * Z2 / Z4 "branch current in pu";
  parameter Complex I2 = If * Z3 / Z4 "branch current in pu";
  parameter Complex delV1 = 0 - Z5 * I1 "bus1 voltage change in pu";
  parameter Complex delV2 = 0 - Z5 * I2 "bus2 voltage change in pu";
  parameter Real Vf1(unit = "pu") = 1 + delV1.re "bus1 post fault voltage";
  parameter Real Vf2(unit = "pu") = 1 + delV2.re "bus2 post fault voltage";
  parameter Complex I13 = (Vf1 - Vf2) / (Z5 + Z6) "branch current in pu";
  parameter Complex delV3 = 0 - (Z5 * I1 + Z5 * I13) "bus3 voltage change in pu";
  parameter Real Vf3(unit = "pu") = 1 + delV3.re "bus3 post fault voltage";
  parameter Real Vf4(unit = "pu") = 0 "bus4 post fault voltage";
  parameter Real SC_MVA(final quantity="Power", final unit="MVA") = S_n / X10 "SC MVA at bus4";
equation
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{70, -90}, {70, -90}, {70, -94}, {80, -94}, {80, -86}, {74, -86}, {74, -86}}, color = {0, 0, 127}));
  connect(order22.vf0, order22.vf) annotation(
    Line(points = {{60, -86}, {54, -86}, {54, -94}, {64, -94}, {64, -90}, {64, -90}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-68, 84}, {-68, 84}, {-68, 88}, {-58, 88}, {-58, 80}, {-64, 80}, {-64, 80}}, color = {0, 0, 127}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-78, 80}, {-84, 80}, {-84, 88}, {-74, 88}, {-74, 84}, {-74, 84}}, color = {0, 0, 127}));
  connect(bus1.p, pwLine5.p) annotation(
    Line(points = {{-72, 20}, {-64, 20}, {-64, -4}, {-10, -4}, {-10, -4}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.p) annotation(
    Line(points = {{-72, -32}, {-68, -32}, {-68, -40}, {-12, -40}, {-12, -40}}, color = {0, 0, 255}));
  connect(breaker1.r, pwFault1.p) annotation(
    Line(points = {{-72, -59}, {-72, -73}}, color = {0, 0, 255}));
  connect(breaker1.s, bus3.p) annotation(
    Line(points = {{-72, -49}, {-72, -32}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus3.p) annotation(
    Line(points = {{-72, -11}, {-72, -32}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine3.p) annotation(
    Line(points = {{-72, 20}, {-72, 7}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-72, 20}, {-66, 20}, {-66, 30}, {-13, 30}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-72, 31}, {-72, 20}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, order21.p) annotation(
    Line(points = {{-72, 53}, {-72, 68}, {-71, 68}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus4.p) annotation(
    Line(points = {{6, -40}, {62, -40}, {62, -34}, {62, -34}}, color = {0, 0, 255}));
  connect(pwLine5.n, bus4.p) annotation(
    Line(points = {{7, -4}, {54, -4}, {54, -34}, {62, -34}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{6, 30}, {50, 30}, {50, 18}, {58, 18}, {58, 18}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, order22.p) annotation(
    Line(points = {{66, -64}, {66, -64}, {66, -74}, {68, -74}}, color = {0, 0, 255}));
  connect(bus4.p, twoWindingTransformer2.p) annotation(
    Line(points = {{62, -34}, {66, -34}, {66, -43}}, color = {0, 0, 255}));
  connect(pwLine4.n, bus4.p) annotation(
    Line(points = {{62, -11}, {62, -34}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine4.p) annotation(
    Line(points = {{58, 18}, {62, 18}, {62, 7}}, color = {0, 0, 255}));
  connect(voltDependant1.p, bus2.p) annotation(
    Line(points = {{58, 58}, {58, 18}}, color = {0, 0, 255}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");


end Ex9_5;
