model Ex9_8
OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-60, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {80, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {8,0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = b12)  annotation(
    Placement(visible = true, transformation(origin = {10, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = b13)  annotation(
    Placement(visible = true, transformation(origin = {-34, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = b23)  annotation(
    Placement(visible = true, transformation(origin = {48, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = Z1)  annotation(
    Placement(visible = true, transformation(origin = {-100, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0, G = 0, R = 0, X = Z2)  annotation(
    Placement(visible = true, transformation(origin = {120, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus Refferance_bus annotation(
    Placement(visible = true, transformation(origin = {10, -44}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));

parameter Real Z1(unit = "pu")=0.25"impedance of branch from bus1 to reference bus";
parameter Real Z2(unit = "pu")=Z1"impedance of branch from bus2 to bus1";
parameter Real b12=0.1"impedance of power line1";
parameter Real b13=0.1"impedance of power line2";
parameter Real b23=0.1"impedance of power line3";
//step-1
parameter Real Z_bus_1(unit = "pu")=Z1"bus impedance matrix after adding branch from bus1 to reference bus";
//step-2
parameter Real [2,2]Z_bus_2(unit = "pu")={{Z1,Z2},{Z2,(Z1+b12)}}"bus impedance matrix after adding branch from bus2 to bus1";
//step-3
parameter Real [3,3]Z_bus_3(unit = "pu")={{Z1,Z2,Z1},{Z2,(Z1+b12),Z1},{Z1,Z2,(Z1+b13)}}"bus impedance matrix after adding branch from bus3 to bus1";
//step-4
parameter Real [3,1]Z_bus_4a(unit = "pu")={{Z1},{Z1+b23},{Z2}}"bus impedance matrix";
parameter Real [1,3]Z_bus_4b(unit = "pu")=transpose(Z_bus_4a)"transpose of matrix Z_bus_4a";
parameter Real [3,3]Z_bus_4c(unit = "pu")=Z_bus_4a*Z_bus_4b"product of Z_bus_4a matrix and its transpose";
parameter Real [3,3]Z_bus_4(unit = "pu")=Z_bus_3-(1/(Z1+Z2+b23))*Z_bus_4c"bus impedance matrix after adding branch from bus2 to reference bus";
//step 5
parameter Real [3,1]Z_bus_5a(unit = "pu")={{Z_bus_4[1,2]-Z_bus_4[1,3]},{-Z_bus_4[2,3]+Z_bus_4[2,2]},{Z_bus_4[3,2]-Z_bus_4[3,3]}}"bus impedance matrix";
parameter Real [1,3]Z_bus_5b(unit = "pu")=transpose(Z_bus_5a)"transpose of matrix Z_bus_5a";
parameter Real [3,3]Z_bus_5c(unit = "pu")=Z_bus_5a*Z_bus_5b"product of Z_bus_5a matrix and its transpose";
parameter Real [3,3]Z_bus_5(unit = "pu")=Z_bus_4-((1/(b23+Z_bus_4[2,2]+Z_bus_4[3,3]-(2*Z_bus_4[2,3])))*Z_bus_5c)"bus impedance matrix after adding branch from bus2 to bus3";
//opening a line
parameter Real [3,1]Z_bus_6a(unit = "pu")={{Z_bus_5[1,3]-Z_bus_5[1,2]},{Z_bus_5[2,3]-Z_bus_5[2,2]},{Z_bus_5[3,3]-Z_bus_5[3,2]}}"bus impedance matrix";
parameter Real [1,3]Z_bus_6b(unit = "pu")=transpose(Z_bus_6a)"transpose of matrix Z_bus_6a";
parameter Real [3,3]Z_bus_6c(unit = "pu")=Z_bus_6a*Z_bus_6b"product of Z_bus_6a matrix and its transpose";
parameter Real [3,3]Z_bus_6(unit = "pu")=Z_bus_5-((1/(-b23+Z_bus_5[3,3]+Z_bus_5[2,2]-(2*Z_bus_5[3,2])))*Z_bus_6c)"bus impedance matrix after opening line 3-2";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-137, 61}, extent = {{-21, -19}, {21, 19}}, rotation = 0)));
equation
  connect(bus2.p, pwLine5.p) annotation(
    Line(points = {{80, 34}, {120, 34}, {120, -1}}, color = {0, 0, 255}));
  connect(pwLine5.n, Refferance_bus.p) annotation(
    Line(points = {{120, -19}, {120, -44}, {10, -44}}, color = {0, 0, 255}));
  connect(pwLine4.n, Refferance_bus.p) annotation(
    Line(points = {{-100, -19}, {-100, -44}, {10, -44}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.p) annotation(
    Line(points = {{8, 0}, {39, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus3.p) annotation(
    Line(points = {{-25, 0}, {8, 0}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-60, 34}, {1, 34}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{19, 34}, {80, 34}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.p) annotation(
    Line(points = {{-60, 34}, {-60, 0}, {-43, 0}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus2.p) annotation(
    Line(points = {{57, 0}, {80, 0}, {80, 34}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine4.n) annotation(
    Line(points = {{-60, 34}, {-100, 34}, {-100, -19}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex9_8;
