model Ex1_2
  parameter Real load(final quantity = "Power", final unit = "MW") = 500 "maximum demand";
  parameter Real pf = 0.5 "load factor";
  parameter Real cost_1(unit = "Rs/kW/annum") = 600 "hydro plant cost";
  parameter Real cost_2(unit = "Rs/kW/annum") = 300 "thermal plant cost";
  parameter Real p1(unit = "paise/kWh") = 0.03 "operating expense of hydro plant";
  parameter Real p2(unit = "paise/kWh") = 0.13 "operating expense of thermal plant";
  parameter Real total_day(final quantity = "Time", final unit = "hours") = 24 * 365"total hour in a year";
  parameter Real t(final quantity = "Time", final unit = "hours") = 3000 "working time";
  parameter Real input_demand(final quantity = "Power", final unit = "kVA") = load / pf "input demand ";
  parameter Real E_total(final quantity = "Energy", final unit = "kWh") = load * pf * input_demand * total_day "total energy generated per year";
  parameter Real E(final quantity = "Energy", final unit = "kWh") = load * input_demand "energy generated by hydro plant per year";
  parameter Modelica.SIunits.Power P = E - E * t / total_day "hydro capacity";
  parameter Real P_MW(final quantity = "Power", final unit = "MW") = P / 1000 "hydro capacity";
  parameter Modelica.SIunits.Power c_thermal = E - P "capacity of thermal plant";
  parameter Real c_thermal_MW(final quantity = "Power", final unit = "MW") = c_thermal / 1000 "capacity of thermal plant";
  parameter Real E_thermal(final quantity = "Energy", final unit = "kWh") = c_thermal_MW * t * input_demand / 2 "Energy generated by thermal plant";
  parameter Real E_hydro(final quantity = "Energy", final unit = "kWh") = E_total - E_thermal "Energy generated by hydro plant";
  parameter Real cost_total(unit = "Rs/year") = cost_1 * P + p1 * E_hydro + cost_2 * (E - P) + p2 * (E_total - E_hydro) "Total annual cost";
  parameter Real cost_overall(unit = "paise/kWh") = cost_total / E_total * 100 "overall generation cost";
  //The answers may slightly vary due to rounding off values.
end Ex1_2;
