model Ex1_3
  parameter Real max_demand(final quantity = "Power", final unit = "MW") = 25 "maximum demand of generating station";
  parameter Real pf = 0.6 "load factor";
  parameter Real cf = 0.5 "plant capacity factor";
  parameter Real puf = 0.72 "plant use factor";
  parameter Real avg_demand(final quantity = "Power", final unit = "MW") = max_demand * pf "average demand";
  parameter Real installed_capacity(final quantity = "Power", final unit = "MW") = avg_demand / cf "installed capacity of plant";
  parameter Real rev_capacity(final quantity = "Power", final unit = "MW") = installed_capacity - max_demand "reserve capacity of plant";
  parameter Real E_daily(final quantity = "Energy", final unit = "MWh") = avg_demand * 24 "daily energy produced ";
  parameter Real E_daily1(final quantity = "Energy", final unit = "MWh") = installed_capacity * 24 "energy correspond to installed capacity per day";
  parameter Real E_total(final quantity = "Energy", final unit = "MWh/day") = E_daily / puf "max energy that could be produced";
end Ex1_3;
