model Ex1_4
  parameter Modelica.SIunits.Power max_demand = 20000 "maximum demand on the plant";
  parameter Modelica.SIunits.Power demand_1 = 14000 "max demand on unit 1";
  parameter Modelica.SIunits.Power demand_2 = max_demand - demand_1 "max demand on unit 2";
  parameter Real l1(final quantity = "Power", final unit = "MW") = 14 "load of unit 1";
  parameter Real l2(final quantity = "Power", final unit = "MW") = 10 "load of unit 2";
  parameter Real T1 = 1 "working time of unit 1";
  parameter Real T2 = 0.45 "working time of unit 2";
  parameter Real E1(unit = "units") = 1e8 "energy generated by unit 1";
  parameter Real E2(unit = "units") = 7.5 * 1e6 "energy generated by unit 2";
  parameter Real total_day(final quantity = "Time", final unit = "hours") = 24 * 365 "total time";
  parameter Real lf1(unit = "%") = E1 * 100 / (demand_1 * total_day) "annual loadfactor of unit 1";
  parameter Real lf2(unit = "%") = E2 * 100 / (demand_2 * total_day) "annual loadfactor of unit 2";
  parameter Real lf21(unit = "%") = E2 * 100 / (demand_2 * total_day * T2) "loadfactor of unit 2 for the time it takes the load";
  parameter Real cf1(unit = "%") = lf1 "annual plant capacity factor of unit 1 as no reverse is available";
  parameter Real cf2(unit = "%") = E2 * 100 / (l2 * total_day * 1000) "annual plant capacity factor of unit 2";
  parameter Real pf1(unit = "%") = lf1 " plant use factor of unit 1";
  parameter Real pf2(unit = "%") = E2 * 100 / (l2 * T2 * total_day * 1000) " plant use factor of unit 2";
  parameter Real lf_total(unit = "%") = (E1 + E2) * 100 / (max_demand * total_day) "annual load factor of total plant";
  //The answers may slightly vary due to rounding off values.
end Ex1_4;
