model Ex1_7
  parameter Real Cp = 0.4 "power coefficien of wind mill";
  parameter Modelica.SIunits.SurfaceDensity D = 1.24 "density";
  parameter Modelica.SIunits.Radius r = 3 "radius of blades";
  parameter Modelica.SIunits.Velocity V = 5 "velocity of wind";
  constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;
  parameter Modelica.SIunits.Area A = pi * r ^ 2 "area of blades";
  parameter Real p(final quantity = "Power", final unit = "kW") = 0.5 * Cp * D * A * V ^ 3 * 1e-3 "power of wind mill";
end Ex1_7;
