model Ex1_8
  constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;
  parameter Real D(final quantity = "Density", final unit = "kg/m3") = 1.24 "density";
  parameter Modelica.SIunits.Radius r = 5 "radius of blades";
  parameter Modelica.SIunits.Velocity V = 8 "velocity of wind";
  parameter Modelica.SIunits.Area A = pi * r ^ 2 "area of blades";
  parameter Real p_output(final quantity = "Power", final unit = "kW") = 8.5 "output power";
  parameter Real p_input(final quantity = "Power", final unit = "kW") = 0.5 * D * A * V ^ 3 * 1e-3 "input power power";
  parameter Real efficiency(unit = "%") = p_output / p_input * 100 "efficiency of wind energy converting system";
  //The answers may slightly vary due to rounding off values.
end Ex1_8;
