model Ex11_4
parameter Complex Xp=Complex(0,0.18)"positive sequence reactance in pu";
parameter Complex Xn=Complex(0,0.15)"negative sequence reactance in pu";
parameter Real Ea(unit = "pu")=1"sequence voltage";
parameter Modelica.SIunits.Resistance R=2"earthing resistor";
parameter Complex x1eq=(Xp/R)"positive sequence reactance of each generator in pu";
parameter Complex x2eq=(Xn/R)"negative sequence reactance of each generator in pu";
parameter Complex Ia1=(Ea)/(x1eq+x2eq)"symmetrical component of fault current in pu";
parameter Complex Ia11=Complex(0,-(3)^0.5)"symmetrical component of fault current in pu";
parameter Complex If=(Ia11*Ia1)"fault current in pu";
parameter Complex Va1=Ea-(Ia1*x1eq)"symmetrical component of voltage under fault in pu";
parameter Real Va0(unit = "pu")=0 "symmetrical component of voltage under fault as Ia0=0";
parameter Complex Va2=Va1"symmetrical component of voltage under fault in pu";
parameter Complex Va=(Va1+Va2+Va0)"voltage of healthy phase for a line-to-line fault on terminals of the generators in pu";
//The answers may slightly vary due to rounding off values. 
end Ex11_4;
