model Ex12_12a
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-174, 80}, extent = {{-20, -18}, {20, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 gen1(D = 0, M = 24, Sn = 500, Vn = 25, ra = 0.001, x1d = 0.067) annotation(
    Placement(visible = true, transformation(origin = {-108, 72}, extent = {{10, 10}, {-10, -10}}, rotation = 90)));
  OpenIPSL.Electrical.Events.Breaker breaker1(rc_enabled = true, t_o = 0.275) annotation(
    Placement(visible = true, transformation(origin = {-92, -36}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {-60, -76}, extent = {{-4, -4}, {4, 4}}, rotation = 180)));
  OpenIPSL.Electrical.Events.Breaker breaker3 annotation(
    Placement(visible = true, transformation(origin = {-126, -36}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker4 annotation(
    Placement(visible = true, transformation(origin = {56, -76}, extent = {{-4, -4}, {4, 4}}, rotation = 180)));
  OpenIPSL.Electrical.Events.Breaker breaker5(rc_enabled = true, t_o = 0.275) annotation(
    Placement(visible = true, transformation(origin = {94, -36}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker6 annotation(
    Placement(visible = true, transformation(origin = {132, -36}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1.03, V_b = 220, angle_0 = 8.235, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-108, 38}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1, V_b = 220, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {0, -76}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1.02, V_b = 220, angle_0 = 7.16, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {112, 38}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus5(V_0 = 1.0112, V_b = 220, angle_0 = 2.49, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {112, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_0 = 1.074, V_b = 220, angle_0 = 4.32, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-108, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1, V_b = 220) annotation(
    Placement(visible = true, transformation(origin = {1, -92}, extent = {{-6, -7}, {6, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(V_b = 1.03, Vn = 220, r = 0, x = 0.022) annotation(
    Placement(visible = true, transformation(origin = {-108, 14}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.04) annotation(
    Placement(visible = true, transformation(origin = {112, 12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 18, Sn = 300, Vn = 20, ra = 0.001, x1d = 0.1) annotation(
    Placement(visible = true, transformation(origin = {112,72}, extent = {{10, 10}, {-10, -10}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0.018, X = 0.11) annotation(
    Placement(visible = true, transformation(origin = {-2, -44}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0.007, X = 0.04) annotation(
    Placement(visible = true, transformation(origin = {-98, -76}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0.004, X = 0.0235) annotation(
    Placement(visible = true, transformation(origin = {106, -76}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0, t1 = 0.05, t2 = 10) annotation(
    Placement(visible = true, transformation(origin = {-111, -55}, extent = {{-5, 5}, {5, -5}}, rotation = 270)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1(P_0 = 1, Q_0 = 0.44)  annotation(
    Placement(visible = true, transformation(origin = {-109, -31}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2(P_0 = 0.5, Q_0 = 0.16)  annotation(
    Placement(visible = true, transformation(origin = {113, -37}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
//Swing equation for each generator during Fault
Real Pe3"prefault power transfer of generator1";
Real D3"swing equation of generator2";
parameter Real delta3"power angle in degree";
constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion"; 
parameter Modelica.SIunits.Frequency freq = 50 "base frequency";
parameter Real H2(unit = "MJ/MVA") = 12"inertia constant of generator1";
parameter Real H3(unit = "MJ/MVA") = 9"inertia constant of generator2";
parameter Real Pm2(final quantity="Power", final unit="MW")=3.25"mechanical power input to generator1";
parameter Real Pm3(final quantity="Power", final unit="MW")=2.1"mechanical power input to generator2";
parameter Real Pe2(unit = "pu") = 0 "prefault power transfer of generator1";
parameter Real D2(unit = "elect deg/s^2")=((180*freq)/H2)*(Pm2-Pe2)"swing equation of generator1";
equation
Pe3 = 0.1561+5.531*sin((delta3-0.755)*D2R);
D3=((180*freq)/H3)*(Pm3-Pe3);
  connect(breaker6.r, pwLine3.n) annotation(
    Line(points = {{132, -40}, {134, -40}, {134, -76}, {115, -76}}, color = {0, 0, 255}));
  connect(pwLine3.p, breaker4.s) annotation(
    Line(points = {{97, -76}, {61, -76}}, color = {0, 0, 255}));
  connect(bus1.p, breaker4.r) annotation(
    Line(points = {{0, -76}, {51, -76}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker2.r) annotation(
    Line(points = {{-89, -76}, {-65, -76}}, color = {0, 0, 255}));
  connect(bus1.p, breaker2.s) annotation(
    Line(points = {{0, -76}, {-55, -76}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine2.p) annotation(
    Line(points = {{-126, -40}, {-126, -76}, {-107, -76}}, color = {0, 0, 255}));
  connect(pwLine1.p, breaker1.r) annotation(
    Line(points = {{-11, -44}, {-92, -44}, {-92, -40}}, color = {0, 0, 255}));
  connect(pwLine1.n, breaker5.r) annotation(
    Line(points = {{7, -44}, {94, -44}, {94, -40}}, color = {0, 0, 255}));
  connect(gen1.vf, gen1.vf0) annotation(
    Line(points = {{-102, 84}, {-102, 84}, {-102, 92}, {-86, 92}, {-86, 80}, {-96, 80}, {-96, 80}}, color = {0, 0, 127}));
  connect(gen1.pm, gen1.pm0) annotation(
    Line(points = {{-112, 84}, {-114, 84}, {-114, 92}, {-130, 92}, {-130, 80}, {-118, 80}, {-118, 80}}, color = {0, 0, 127}));
  connect(bus5.p, voltDependant2.p) annotation(
    Line(points = {{112, -10}, {114, -10}, {114, -32}, {114, -32}}, color = {0, 0, 255}));
  connect(bus4.p, voltDependant1.p) annotation(
    Line(points = {{-108, -10}, {-108, -10}, {-108, -26}, {-108, -26}}, color = {0, 0, 255}));
  connect(pwFault1.p, breaker1.r) annotation(
    Line(points = {{-110, -50}, {-112, -50}, {-112, -42}, {-92, -42}, {-92, -40}}, color = {0, 0, 255}));
  connect(bus5.p, breaker6.s) annotation(
    Line(points = {{112, -10}, {118, -10}, {118, -20}, {132, -20}, {132, -30}, {132, -30}}, color = {0, 0, 255}));
  connect(bus5.p, breaker5.s) annotation(
    Line(points = {{112, -10}, {108, -10}, {108, -22}, {94, -22}, {94, -30}, {94, -30}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, bus5.p) annotation(
    Line(points = {{112, 1}, {112, -10}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.p, bus3.p) annotation(
    Line(points = {{112, 23}, {112, 38}}, color = {0, 0, 255}));
  connect(order21.p, bus3.p) annotation(
    Line(points = {{112, 62}, {112, 38}}, color = {0, 0, 255}));
  connect(infiniteBus1.p, bus1.p) annotation(
    Line(points = {{1, -86}, {1, -76}, {0, -76}}, color = {0, 0, 255}));
  connect(bus4.p, breaker1.s) annotation(
    Line(points = {{-108, -10}, {-104, -10}, {-104, -20}, {-92, -20}, {-92, -30}, {-92, -30}}, color = {0, 0, 255}));
  connect(bus4.p, breaker3.s) annotation(
    Line(points = {{-108, -10}, {-112, -10}, {-112, -20}, {-126, -20}, {-126, -30}, {-126, -30}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus4.p) annotation(
    Line(points = {{-108, 3}, {-108, -10}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, bus2.p) annotation(
    Line(points = {{-108, 25}, {-108, 38}}, color = {0, 0, 255}));
  connect(gen1.p, bus2.p) annotation(
    Line(points = {{-108, 62}, {-108, 38}}, color = {0, 0, 255}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{101, 80}, {91, 80}, {91, 92}, {107, 92}, {107, 84}, {107, 84}}, color = {0, 0, 127}));
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{123, 80}, {129, 80}, {129, 92}, {115, 92}, {115, 84}, {117, 84}}, color = {0, 0, 127}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex12_12a;
