model Ex12_13
OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.3) annotation(
    Placement(visible = true, transformation(origin = {14, 3.33067e-16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(kT = 1, r = 0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-82, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(kT = 1, r = 0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {98, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-165, 72}, extent = {{-27, -24}, {27, 24}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault Fault(R = 0, X = 0, t1 = 0.075, t2 = 0.325) annotation(
    Placement(visible = true, transformation(origin = {9, -31}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-41, 0}, extent = {{-3, -4}, {3, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {51, 0}, extent = {{-3, -4}, {3, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1.0, angle_0 = 0) annotation(
    Placement(visible = true, transformation(origin = {158, 1}, extent = {{-8, -9}, {8, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8.334, Sn = 100, Vn = 480, ra = 0.001, x1d = 0.3) annotation(
    Placement(visible = true, transformation(origin = {-128, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;  
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Modelica.SIunits.Frequency freq = 50 "base frequency";
parameter Real H(unit = "MJ/MVA") = 4.167 "kinetic energy of generator";
parameter Real M(unit = "s^2/elect degree") = H / (180 * freq) "inertia constant";   
parameter Real X_12_a(unit = "pu")=1.45"transfer reactance of the circuit after star delta transformation for LG fault";
parameter Real X_12_b(unit = "pu")=1.22"transfer reactance of the circuit for faulted line open";
parameter Real X_12_c(unit = "pu")=0.8"transfer reactance of the circuit for healthy line";
parameter Real modE(unit = "pu") = 1.2"voltage of generator";
parameter Real V(unit = "pu") = 1"voltage of infinite bus";
parameter Real Pmax1(unit = "pu") = (modE*V) / X_12_c "maximum power";
parameter Real load_initial(unit = "pu")=1"initial load";  
parameter Real del0(unit = "rad") = asin(load_initial / Pmax1)"prefault operating power angle";
parameter Real del0_new(unit = "degree") =del0*R2D"prefault operating power angle"; 
parameter Modelica.SIunits.Time t1=0.075"single/three pole switching occurs";
parameter Modelica.SIunits.Time t2=0.325"time when reclosing occurs";
  
//case-1
//The procedure of calculations is described below by calculating the rows corresponding to t=0.05s,0.15s and 0.40s respectively of table 12.15 that describes 'swing curve calculation for three-pole switching'
//case-a: During fault at t=0.05s
 parameter Real Pmax2(unit = "pu") = (modE*V) / X_12_a "maximum power during fault";
 parameter Real Pe_old_a(unit = "pu")=0.564"electrical power output at 0.05s";
 parameter Real del_a(unit = "rad") = asin(Pe_old_a / Pmax2)"during fault operating power angle";
parameter Real del_a_new(unit = "degree") =del_a*R2D"during fault operating power angle"; 

//case-b: During three pole switching, the row corresponding to t=0.15s
parameter Real delta_old_b(unit = "degree")=46.6"value of torque angle at 0.1s";
  parameter Real Pmax_old_b(unit = "pu")=0"value of mechanical power input at 0.1s";
  parameter Real sin_delta_old_b=0.726"value of sin(delta) at 0.1s";
  parameter Real del_delta_old_b(unit = "degree")=3.6"increment of torque angle at 0.1s";
  parameter Real Pe_old_b(unit = "pu")=Pmax_old_b*sin_delta_old_b"electrical power output at 0.1s";
  parameter Real Pa_old_b(unit = "pu")=load_initial-Pe_old_b"accelerating power at 0.1s";
  parameter Modelica.SIunits.Time del_t_b=0.05"time period";
  parameter Real Pa_1_old_b(unit = "degree")=((del_t_b^2)/M)*Pa_old_b"accelerating power after multiplying with constant at 0.1s";
  parameter Real del_delta_new_b(unit = "degree")=del_delta_old_b+Pa_1_old_b"increment of torque angle at 0.15s";
  parameter Real delta_new_b(unit = "degree")=delta_old_b+del_delta_new_b"value of torque angle at 0.15s";
//case-c: During reclosing, the row corresponding to t=0.40s
parameter Real delta_old_c(unit = "degree")=145.6"value of torque angle at 0.35s";
  parameter Real Pmax_old_c(unit = "pu")=1.5"value of mechanical power input at 0.35s";
  parameter Real sin_delta_old_c=0.565"value of sin(delta) at 0.35s";
  parameter Real del_delta_old_c(unit = "degree")=30.6"increment of torque angle at 0.35s";
  parameter Real Pe_old_c(unit = "pu")=Pmax_old_c*sin_delta_old_c"electrical power output at 0.35s";
  parameter Real Pa_old_c(unit = "pu")=load_initial-Pe_old_c"accelerating power at 0.35s";
  parameter Modelica.SIunits.Time del_t_c=0.05"time period";
  parameter Real Pa_1_old_c(unit = "degree")=((del_t_c^2)/M)*Pa_old_c"accelerating power after multiplying with constant at 0.35s";
  parameter Real del_delta_new_c(unit = "degree")=del_delta_old_c+Pa_1_old_c"increment of torque angle at 0.40s";
  parameter Real delta_new_c(unit = "degree")=delta_old_c+del_delta_new_c"value of torque angle at 0.40s";
  
//case-2
//The procedure of calculations is described below by calculating the rows corresponding to t=0.05s,0.15s and 0.40s respectively of table 12.16 that describes 'swing curve calculation for single-pole switching'
//case-d: During fault at t=0.05s
 parameter Real Pmax2_d(unit = "pu") = (modE*V) / X_12_a "maximum power during fault";
 parameter Real Pe_old_d(unit = "pu")=0.564"electrical power output at 0.05s";
 parameter Real del_d(unit = "rad") = asin(Pe_old_d / Pmax2_d)"during fault operating power angle";
parameter Real del_d_new(unit = "degree") =del_d*R2D"during fault operating power angle"; 

//case-e: During single pole switching, the row corresponding to t=0.15s
parameter Real delta_old_e(unit = "degree")=46.6"value of torque angle at 0.1s";
  parameter Real Pmax_old_e(unit = "pu")=0.985"value of mechanical power input at 0.1s";
  parameter Real sin_delta_old_e=0.726"value of sin(delta) at 0.1s";
  parameter Real del_delta_old_e(unit = "degree")=3.6"increment of torque angle at 0.1s";
  parameter Real Pe_old_e(unit = "pu")=Pmax_old_e*sin_delta_old_e"electrical power output at 0.1s";
  parameter Real Pa_old_e(unit = "pu")=load_initial-Pe_old_e"accelerating power at 0.1s";
  parameter Modelica.SIunits.Time del_t_e=0.05"time period";
  parameter Real Pa_1_old_e(unit = "degree")=((del_t_e^2)/M)*Pa_old_e"accelerating power after multiplying with constant at 0.1s";
  parameter Real del_delta_new_e(unit = "degree")=del_delta_old_e+Pa_1_old_e"increment of torque angle at 0.15s";
  parameter Real delta_new_e(unit = "degree")=delta_old_e+del_delta_new_e"value of torque angle at 0.15s";
//case-f: During reclosing, the row corresponding to t=0.40s
parameter Real delta_old_f(unit = "degree")=81.1"value of torque angle at 0.35s";
  parameter Real Pmax_old_f(unit = "pu")=1.5"value of mechanical power input at 0.35s";
  parameter Real sin_delta_old_f=0.988"value of sin(delta) at 0.35s";
  parameter Real del_delta_old_f(unit = "degree")=8.1"increment of torque angle at 0.35s";
  parameter Real Pe_old_f(unit = "pu")=Pmax_old_f*sin_delta_old_f"electrical power output at 0.35s";
  parameter Real Pa_old_f(unit = "pu")=load_initial-Pe_old_f"accelerating power at 0.35s";
  parameter Modelica.SIunits.Time del_t_f=0.05"time period";
  parameter Real Pa_1_old_f(unit = "degree")=((del_t_f^2)/M)*Pa_old_f"accelerating power after multiplying with constant at 0.35s";
  parameter Real del_delta_new_f(unit = "degree")=del_delta_old_f+Pa_1_old_f"increment of torque angle at 0.40s";
  parameter Real delta_new_f(unit = "degree")=delta_old_f+del_delta_new_f"value of torque angle at 0.40s";
//The answers may slightly vary due to rounding off values.

equation
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-136, -10}, {-136, -10}, {-136, -20}, {-148, -20}, {-148, -6}, {-140, -6}, {-140, -4}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-136, 12}, {-136, 12}, {-136, 20}, {-148, 20}, {-148, 6}, {-140, 6}, {-140, 6}}, color = {0, 0, 127}));
  connect(pwLine1.n, breaker2.s) annotation(
    Line(points = {{23, 0}, {47, 0}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine1.p) annotation(
    Line(points = {{-37, 0}, {5, 0}}, color = {0, 0, 255}));
  connect(breaker2.r, twoWindingTransformer2.p) annotation(
    Line(points = {{55, 0}, {87, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, infiniteBus1.p) annotation(
    Line(points = {{110, 0}, {166, 0}, {166, 2}, {166, 2}}, color = {0, 0, 255}));
  connect(Fault.p, breaker1.r) annotation(
    Line(points = {{1, -31}, {-18, -31}, {-18, 0}, {-37, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, breaker1.s) annotation(
    Line(points = {{-71, 0}, {-45, 0}}, color = {0, 0, 255}));
  connect(generator1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-118, 0}, {-93, 0}}, color = {0, 0, 255}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex12_13;
