model Ex12_3
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-174, 76}, extent = {{-18, -16}, {18, 16}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {78, -1.11022e-15}, extent = {{-14, -14}, {14, 14}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1, V_b = 400, angle_0 = 0) annotation(
    Placement(visible = true, transformation(origin = {148, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = X3) annotation(
    Placement(visible = true, transformation(origin = {16, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {16, -10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-52, 0}, extent = {{-14, -14}, {14, 14}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(V_b = 400, kT = 1, r = 0, x = X2) annotation(
    Placement(visible = true, transformation(origin = {-88, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 Generator1(D = 0, M = 8, Sn = 100, Vn = 400, ra = 0.001, x1d = X1) annotation(
    Placement(visible = true, transformation(origin = {-134, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;  
  parameter Real X1(unit = "pu")=0.25"reactance of generator1";
  parameter Real X2(unit = "pu")=0.1"reactance of transformer";
  parameter Real X3(unit = "pu")=0.5"reactance of powerline1";
  parameter Real V_mod(unit = "pu")=1"infinite bus voltage";
  parameter Real Vt_mod(unit = "pu")=1"generator terminal voltage";
  parameter Real Pe(unit = "pu")=1"electrical power";
  parameter Real X11(unit = "pu")=X1+X2+(X3/2)"reactance between two buses when the system is healthy";
  parameter Complex X12=Complex(0,X11)"reactance between two buses when the system is healthy in complex form in pu";
  parameter Complex X=Complex(0,(X1+X2))"transient reactance in pu";
  parameter Real alfa(unit = "rad")=asin((Pe*(X1+X2))/(V_mod*Vt_mod))"power angle";
  parameter Real alfa1(unit = "degree")=alfa*R2D"power angle";
  parameter Complex Vt_1 = Complex(Vt_mod * cos(alfa), Vt_mod * sin(alfa))"generator terminal voltage in complex form";
  parameter Complex V_1 = Complex(V_mod * cos(0), V_mod * sin(0))"infinite bus voltage in complex form";
  parameter Complex I=(Vt_1-V_1)/X"current into infinite bus";
  parameter Complex E=V_1+X12*I"voltage behind transient reactance";
  parameter Real E_abs = (E.re ^ 2 + E.im ^ 2) ^ 0.5"absolute value of voltage behind transient reactance";
  parameter Real E_arg(unit = "degree") = atan(E.im / E.re) * R2D "angle of voltage behind transient reactance";
  //solution for a
  parameter Real Pmax1(unit = "pu")=(V_mod*E_abs)/X12.im"maximum power that can be transferred when the system is healthy";
  // solution for b
  parameter Real X13(unit = "pu")=((X1*(X1+X2))+((X1+X2)*X3)+(X3*X1))/X1"reactance between two buses when one line is shorted in the middle";
  parameter Real Pmax2(unit = "pu")=(V_mod*E_abs)/X13"maximum power that can be transferred when one line is shorted in the middle";
  //solution for c
  parameter Real X14(unit = "pu")=X1+X2+X3"reactance between two buses when one line is opened";
  parameter Real Pmax3(unit = "pu")=(V_mod*E_abs)/X14"maximum power that can be transferred when one line is opened";
 //The answers may slightly vary due to rounding off values.   
equation
  connect(pwLine2.p, bus1.p) annotation(
    Line(points = {{7, -10}, {-52, -10}, {-52, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus2.p) annotation(
    Line(points = {{25, -10}, {78, -10}, {78, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{25, 12}, {78, 12}, {78, 0}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus1.p) annotation(
    Line(points = {{7, 12}, {-52, 12}, {-52, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-77, 0}, {-52, 0}}, color = {0, 0, 255}));
  connect(Generator1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-124, 0}, {-99, 0}}, color = {0, 0, 255}));
  connect(infiniteBus1.p, bus2.p) annotation(
    Line(points = {{138, 0}, {78, 0}}, color = {0, 0, 255}));
  connect(Generator1.vf0, Generator1.vf) annotation(
    Line(points = {{-142, 11}, {-154, 11}, {-154, 3}, {-146, 3}, {-146, 5}}, color = {0, 0, 127}));
  connect(Generator1.pm0, Generator1.pm) annotation(
    Line(points = {{-142, -11}, {-154, -11}, {-154, -3}, {-146, -3}, {-146, -5}}, color = {0, 0, 127}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");


end Ex12_3;
