model Ex12_7
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-161, 68}, extent = {{-21, -20}, {21, 20}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {-22, 24}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.05) annotation(
    Placement(visible = true, transformation(origin = {100, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {-20, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {16, -50}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {-56, -50}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1, angle_0 = 0) annotation(
    Placement(visible = true, transformation(origin = {156, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-106, -1.33227e-15}, extent = {{-12, -12}, {12, 12}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {64, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault Fault(R = 0, X = 1.2, t1 = 5, t2 = 50) annotation(
    Placement(visible = true, transformation(origin = {8, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator_1(D = 0, M = 8, Sn = 100, Vn = 480, ra = 0.001, x1d = 0.25) annotation(
    Placement(visible = true, transformation(origin = {-146, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;  
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion"; 
parameter Real X1(unit = "pu")=0.25"reactance of generator";
parameter Real X2(unit = "pu")=0.5"reactance of powerline1";
parameter Real X3(unit = "pu")=0.4"reactance of powerline2";
parameter Real X4(unit = "pu")=0.05"reactance of powerline3";
parameter Real X(unit = "pu")=X1+((X2*X3)/(X2+X3))+X4"total reactance at prefault condition";
parameter Real Pe(unit = "pu")=1"prefault operating power";
parameter Real delta_0(unit = "rad")=asin(Pe/2.3)"prefault operating power angle";
parameter Real delta_0_new(unit = "degree")=delta_0*R2D"prefault operating power angle";
parameter Real Pe_III(unit = "pu")=1"postfault operating power";
parameter Real delta_max(unit = "rad")=pi-asin(Pe_III/1.5)"maximum permissible angle";
//Applying equal area criterion for critical angle we get
parameter Real delta_cr(unit = "rad")=acos(0.843/1.5)"fault clearing angle";
parameter Real delta_cr_new(unit = "degree")=delta_cr*R2D"fault clearing angle";
 //The answers may slightly vary due to rounding off values.   
equation
  connect(pwLine1.p, breaker2.s) annotation(
    Line(points = {{-31, 24}, {-70, 24}, {-70, -50}, {-61, -50}}, color = {0, 0, 255}));
  connect(pwLine1.n, breaker1.r) annotation(
    Line(points = {{-13, 24}, {28, 24}, {28, -50}, {22, -50}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine1.n) annotation(
    Line(points = {{64, 0}, {28, 0}, {28, 24}, {-13, 24}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-106, 0}, {-70, 0}, {-70, 24}, {-31, 24}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.p) annotation(
    Line(points = {{64, 0}, {91, 0}}, color = {0, 0, 255}));
  connect(pwLine3.n, infiniteBus1.p) annotation(
    Line(points = {{109, 0}, {166, 0}}, color = {0, 0, 255}));
  connect(bus1.p, generator_1.p) annotation(
    Line(points = {{-106, 0}, {-136, 0}}, color = {0, 0, 255}));
  connect(generator_1.vf0, generator_1.vf) annotation(
    Line(points = {{-154, 11}, {-168, 11}, {-168, 5}, {-158, 5}, {-158, 5}}, color = {0, 0, 127}));
  connect(generator_1.pm0, generator_1.pm) annotation(
    Line(points = {{-154, -11}, {-168, -11}, {-168, -5}, {-158, -5}, {-158, -5}}, color = {0, 0, 127}));
  connect(Fault.p, pwLine2.n) annotation(
    Line(points = {{0, -80}, {-4, -80}, {-4, -50}, {-10, -50}, {-10, -50}, {-10, -50}}, color = {0, 0, 255}));
  connect(breaker2.r, pwLine2.p) annotation(
    Line(points = {{-51, -50}, {-29, -50}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker1.s) annotation(
    Line(points = {{-11, -50}, {11, -50}}, color = {0, 0, 255}));
protected
  parameter Real S_b = SysData.S_b;
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}}, preserveAspectRatio = false)),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}}, preserveAspectRatio = false)),
    experiment(StopTime = 10, Interval = 0.0001, Tolerance = 1e-006, __Dymola_fixedstepsize = 0.0001, __Dymola_Algorithm = "Rkfix2"),
    __Dymola_experimentSetupOutput,
    Documentation(info = "<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>SMIB PSAT, d_kundur2.mdl, PSAT</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>February 2016</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Maxime Baudette, Ahsan Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"),
  __OpenModelica_commandLineOptions = "");


end Ex12_7;
