model Ex12_8
 OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1.0, angle_0 = 0) annotation(
    Placement(visible = true, transformation(origin = {247, -1}, extent = {{-9, -9}, {9, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-190, 0}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {130, -4.10783e-15}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.28) annotation(
    Placement(visible = true, transformation(origin = {0, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = 0.15) annotation(
    Placement(visible = true, transformation(origin = {188, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.14) annotation(
    Placement(visible = true, transformation(origin = {-20, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.14) annotation(
    Placement(visible = true, transformation(origin = {12, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(x = 0.15) annotation(
    Placement(visible = true, transformation(origin = {-54, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(x = 0.15) annotation(
    Placement(visible = true, transformation(origin = {54, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer3(x = 0.15) annotation(
    Placement(visible = true, transformation(origin = {-70, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer4(x = 0.15) annotation(
    Placement(visible = true, transformation(origin = {64, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-239, 121}, extent = {{-31, -35}, {31, 35}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault Fault(R = 0, X = 0.01, t1 = 5, t2 = 50) annotation(
    Placement(visible = true, transformation(origin = {14, -90}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-92, -54}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {-46, -54}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3 annotation(
    Placement(visible = true, transformation(origin = {36, -54}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4 annotation(
    Placement(visible = true, transformation(origin = {86, -54}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker5 annotation(
    Placement(visible = true, transformation(origin = {-90, 34}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker6 annotation(
    Placement(visible = true, transformation(origin = {-28, 34}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker7 annotation(
    Placement(visible = true, transformation(origin = {26, 34}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker8 annotation(
    Placement(visible = true, transformation(origin = {80, 34}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 100, Vn = 480, ra = 0.001, x1d = 0.25) annotation(
    Placement(visible = true, transformation(origin = {-248, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);
  // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi "Radian to degree conversion";
  parameter Real D2R = pi / 180 "Degree to radian conversion";
  parameter Real Xg(unit = "pu") = 0.25 "reactance of generator";
  parameter Real Xl4(unit = "pu") = 0.17 "reactance of powerline4";
  parameter Real Xt(unit = "pu") = 0.15 "reactance of each transformer";
  parameter Real Xl1(unit = "pu") = 0.28 "reactance of powerline1";
  parameter Real X1(unit = "pu") = Xg + Xl4 + (2 * Xt + Xl1) / 2 "transfer reactance between genertor and infinite bus";
  parameter Real Pe(unit = "pu") = 1 "prefault operating power";
  parameter Real delta_0(unit = "rad") = asin(Pe / 1.69) "prefault operating power angle";
  parameter Real delta_0_new(unit = "degree") = delta_0 * R2D "prefault operating power angle";
  parameter Real X2(unit = "pu") = 2.424 "transfer reactance between genertor and infinite bus during fault";
  parameter Real X3(unit = "pu") = Xg + 2 * Xt + Xl1 + Xl4 "transfer reactance between genertor and infinite bus during postfault condition";
  parameter Real Pe_III(unit = "pu") = 1 "postfault operating power";
  parameter Real delta_max(unit = "rad") = pi - asin(Pe_III / 1.2) "maximum permissible angle";
  //Applying equal area criterion for critical angle we get
  parameter Real delta_cr(unit = "rad") = acos(0.655) "fault clearing angle";
  parameter Real delta_cr_new(unit = "degree") = delta_cr * R2D "fault clearing angle";
  //The answers may slightly vary due to rounding off values.
equation
  connect(bus2.p, pwLine4.p) annotation(
    Line(points = {{130, 0}, {179, 0}}, color = {0, 0, 255}));
  connect(breaker4.r, bus2.p) annotation(
    Line(points = {{91, -54}, {96, -54}, {96, 0}, {130, 0}}, color = {0, 0, 255}));
  connect(breaker8.r, bus2.p) annotation(
    Line(points = {{85, 34}, {96, 34}, {96, 0}, {130, 0}}, color = {0, 0, 255}));
  connect(pwLine4.n, infiniteBus1.p) annotation(
    Line(points = {{197, 0}, {165.5, 0}, {165.5, -1}, {256, -1}}, color = {0, 0, 255}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-238, 0}, {-190, 0}}, color = {0, 0, 255}));
  connect(breaker1.s, bus1.p) annotation(
    Line(points = {{-97, -54}, {-112, -54}, {-112, 0}, {-190, 0}}, color = {0, 0, 255}));
  connect(breaker5.s, bus1.p) annotation(
    Line(points = {{-95, 34}, {-112, 34}, {-112, 0}, {-190, 0}}, color = {0, 0, 255}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-256, -10}, {-256, -10}, {-256, -14}, {-266, -14}, {-266, -4}, {-260, -4}, {-260, -4}}, color = {0, 0, 127}));
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{-256, 12}, {-256, 12}, {-256, 14}, {-266, 14}, {-266, 4}, {-260, 4}, {-260, 6}}, color = {0, 0, 127}));
  connect(breaker6.r, pwLine1.p) annotation(
    Line(points = {{-23, 34}, {-9, 34}}, color = {0, 0, 255}));
  connect(pwLine1.n, breaker7.s) annotation(
    Line(points = {{9, 34}, {21, 34}}, color = {0, 0, 255}));
  connect(breaker7.r, twoWindingTransformer2.p) annotation(
    Line(points = {{31, 34}, {43, 34}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, breaker8.s) annotation(
    Line(points = {{65, 34}, {75, 34}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, breaker6.s) annotation(
    Line(points = {{-43, 34}, {-33, 34}}, color = {0, 0, 255}));
  connect(breaker5.r, twoWindingTransformer1.p) annotation(
    Line(points = {{-85, 34}, {-65, 34}}, color = {0, 0, 255}));
  connect(twoWindingTransformer4.n, breaker4.s) annotation(
    Line(points = {{75, -54}, {81, -54}}, color = {0, 0, 255}));
  connect(breaker3.r, twoWindingTransformer4.p) annotation(
    Line(points = {{41, -54}, {53, -54}}, color = {0, 0, 255}));
  connect(pwLine3.n, breaker3.s) annotation(
    Line(points = {{21, -54}, {31, -54}}, color = {0, 0, 255}));
  connect(pwLine2.n, pwLine3.p) annotation(
    Line(points = {{-11, -54}, {3, -54}}, color = {0, 0, 255}));
  connect(Fault.p, pwLine2.n) annotation(
    Line(points = {{7, -90}, {-4, -90}, {-4, -54}, {-11, -54}}, color = {0, 0, 255}));
  connect(breaker2.r, pwLine2.p) annotation(
    Line(points = {{-41, -54}, {-29, -54}}, color = {0, 0, 255}));
  connect(twoWindingTransformer3.n, breaker2.s) annotation(
    Line(points = {{-59, -54}, {-51, -54}}, color = {0, 0, 255}));
  connect(breaker1.r, twoWindingTransformer3.p) annotation(
    Line(points = {{-87, -54}, {-81, -54}}, color = {0, 0, 255}));
  annotation(
    Diagram(coordinateSystem(extent = {{-300, -170}, {300, 170}})),
    Icon(coordinateSystem(extent = {{-300, -170}, {300, 170}})),
    __OpenModelica_commandLineOptions = "");

end Ex12_8;
