model Ex14_1
parameter Real El_l(final quantity="ElectricPotential", final unit="kV") = 38 "rms line to line alternating voltage";
  constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
  parameter Real Vd0(final quantity="ElectricPotential", final unit="kV") = 3 * 2 ^ 0.5 / pi * El_l"avg direct voltage";
  //Case_1
  parameter Real Alfa1(unit = "degree") = 0 "delay angle";
  parameter Real delta1(unit = "degree") = Alfa1 + 15 "extinction angle";
  parameter Real Alfa11(unit = "rad") = pi / 180 * Alfa1"delay angle";
  parameter Real delta11(unit = "rad") = pi / 180 * delta1"extinction angle";
  parameter Real Vd1(final quantity="ElectricPotential", final unit="kV") = Vd0 / 2 * (cos(Alfa11) + cos(delta11)) "gross voltage output";
  //Case_2
  parameter Real Alfa2(unit = "degree") = 15 "delay angle";
  parameter Real delta2(unit = "degree") = Alfa2 + 15 "extinction angle";
  parameter Real Alfa21(unit = "rad") = pi / 180 * Alfa2"delay angle";
  parameter Real delta22(unit = "rad") = pi / 180 * delta2"extinction angle";
  parameter Real Vd2(final quantity="ElectricPotential", final unit="kV") = Vd0 / 2 * (cos(Alfa21) + cos(delta22)) "gross voltage output";
  //case_3
  parameter Real Alfa3(unit = "degree") = 30 "delay angle";
  parameter Real delta3(unit = "degree") = Alfa3 + 15 "extinction angle";
  parameter Real Alfa31(unit = "rad") = pi / 180 * Alfa3"delay angle";
  parameter Real delta32(unit = "rad") = pi / 180 * delta3"extinction angle";
  parameter Real Vd3(final quantity="ElectricPotential", final unit="kV") = Vd0 / 2 * (cos(Alfa31) + cos(delta32)) "gross voltage output";
  //case_4
  parameter Real Alfa4(unit = "degree") = 45 "delay angle";
  parameter Real delta4(unit = "degree") = Alfa4 + 15 "extinction angle";
  parameter Real Alfa41(unit = "rad") = pi / 180 * Alfa4"delay angle";
  parameter Real delta42(unit = "rad") = pi / 180 * delta4"extinction angle";
  parameter Real Vd4(final quantity="ElectricPotential", final unit="kV") = Vd0 / 2 * (cos(Alfa41) + cos(delta42)) "gross voltage output";
  //The answers may slightly vary due to rounding off values.
end Ex14_1;
