model Ex2_4
// This model will not be simulated as it is a derivation
parameter Modelica.SIunits.Current Ia"current of conductor a";
parameter Modelica.SIunits.Current Ib"current of conductor b";
parameter Modelica.SIunits.Current Ic"current of conductor c";
parameter Modelica.SIunits.Distance Da1"distance of conductor a from conductor t1";
parameter Modelica.SIunits.Distance Db1"distance of conductor b from conductor t1";
parameter Modelica.SIunits.Distance Dc1"distance of conductor c from conductor t1";
parameter Modelica.SIunits.Distance Da2"distance of conductor a from conductor t2";
parameter Modelica.SIunits.Distance Db2"distance of conductor b from conductor t2";
parameter Modelica.SIunits.Distance Dc2"distance of conductor c from conductor t2";
parameter Real lambda_t1I(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")"Flux linkage of conductor t1 in 1st transposition section of power line";
parameter Real lambda_t1II(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")"Flux linkage of conductor t1 in 2nd transposition section of power line";
parameter Real lambda_t1III(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")"Flux linkage of conductor t1 in 3rd transposition section of power line";
parameter Real lambda_t2I(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")"Flux linkage of conductor t2 in 1st transposition section of power line";
parameter Real lambda_t2II(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")"Flux linkage of conductor t2 in 2nd transposition section of power line";
parameter Real lambda_t2III(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")"Flux linkage of conductor t2 in 3rd transposition section of power line";
parameter Real lambda_t1(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2*1e-7*((Ia*log(1/Da1))+(Ib*log(1/Db1))+(Ic*log(1/Dc1)))"Flux linkage of conductor t1";
parameter Real lambda_t2(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2e-7*((Ia*log(1/Da2))+(Ib*log(1/Db2))+(Ic*log(1/Dc2)))"Flux linkage of conductor t2";
parameter Real lambda_t(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=lambda_t1-lambda_t2"Net flux linkage of the telephone line";
parameter Real Et(unit = "v/m")=2*3.14*lambda_t"emf induced in telephone line loop";
parameter Real lambda_t11(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=(lambda_t1I+lambda_t1II+lambda_t1III)/3"Flux linkage of conductor t1 if power line is fully transposed w.r.t telephone line";
parameter Real lambda_t21(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=(lambda_t2I+lambda_t2II+lambda_t2III)/3"Flux linkage of conductor t2 if power line is fully transposed w.r.t telephone line";
parameter Real lambda_t_1(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2e-7*(Ia+Ib+Ic)*log(1/((Da1*Db1*Dc1)^(1/3)))"values of lambda_t1 in terms of flux linkages of telephone line in the three transposition sections pf power line";
parameter Real lambda_t_2(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2e-7*(Ia+Ib+Ic)*log(1/((Da2*Db2*Dc2)^(1/3)))"values of lambda_t2 in terms of flux linkages of telephone line in the three transposition sections pf power line";
parameter Real lambda_t_new(final quantity="MagneticFluxlinkage", final unit="Wb-T/m")=2e-7*(Ia+Ib+Ic)*log(((Da2*Db2*Dc2)^(1/3))/((Da1*Db1*Dc1)^(1/3)))"values of lambda_t in terms of flux linkages of telephone line in the three transposition sections pf power line";
// From above expression it is cleared that: If (Ia+Ib+Ic)=0 then lambda_t_new=0
end Ex2_4;
