model Ex2_7
parameter Modelica.SIunits.Frequency f=50"line frequency";
parameter Modelica.SIunits.Distance d=7"distance between the conductors";
parameter Modelica.SIunits.Distance s=0.4"distance between a and a',b and b' and also c and c'";
parameter Real r(final quantity="Radius", final unit="cm")=1.725"radius of conductor";
parameter Real r2(final quantity="Radius", final unit="cm")=(2^0.5)*1.725"radius of bundle of conductor";
parameter Real w=314"a constant value";
parameter Modelica.SIunits.Radius R=0.7788*r*1e-2"another value of radius of conductor ";
parameter Modelica.SIunits.Radius R2=0.7788*r2*1e-3"another value of radius of bundle of conductor";
parameter Modelica.SIunits.Distance D_ab=(d*(d+s)*(d-s)*d)^(1/4)"distance between bundles of phase a and b";
parameter Modelica.SIunits.Distance D_bc=D_ab"distance between bundles of phase b and c";
parameter Modelica.SIunits.Distance D_ca=(2*d*((2*d)+s)*((2*d)-s)*2*d)^(1/4)"distance between bundles of phase c and a";
parameter Modelica.SIunits.Distance D_eq=(D_ab*D_bc*D_ca)^(1/3)"equivalent equilateral spacing";
parameter Modelica.SIunits.Distance D_s=(R*s*R*s)^(1/4)"Equivalent self GMD";
parameter Real Xl(final quantity="InductiveReactance",final unit="Ohms/km")=w*0.461*1e-3*log10(D_eq/D_s)"Inductive reactance per phase";
parameter Modelica.SIunits.Distance D_ab_1=d"distance between bundles of phase a and b using the centre to centre distances between bundles";
parameter Modelica.SIunits.Distance D_bc_1=D_ab"distance between bundles of phase b and c using the centre to centre distances between bundles";
parameter Modelica.SIunits.Distance D_ca_1=2*d"distance between bundles of phase c and a using the centre to centre distances between bundles";
parameter Modelica.SIunits.Distance D_eq_1=(D_ab_1*D_bc_1*D_ca_1)^(1/3)"equivalent equilateral spacing using the centre to centre distances between bundles";
parameter Real Xl_1(final quantity="InductiveReactance",final unit="Ohms/km")=w*0.461*1e-3*log10(D_eq_1/D_s)"Inductive reactance per phase using the centre to centre distances between bundles ";
// Another case using another value of conductor's diameter
parameter Real Xl_2(final quantity="InductiveReactance",final unit="Ohms/km")=w*0.461*1e-3*log10(D_eq_1/R2)"Inductive reactance per phase in another case";
parameter Real diff(unit = "%")=((Xl_2-Xl_1)/Xl_1)*100"comparison between 2 cases inductive reactance per phase";
//The answer may slightly vary due to rounding off values.

end Ex2_7;
