model Ex3_3
parameter Modelica.SIunits.Frequency frequency=50"line frequency";
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Modelica.SIunits.Radius r=0.865e-2"conductor radius";
parameter Real V(final quantity="ElectricPotential", final unit="kV")=110"line voltage";
parameter Modelica.SIunits.Height h=6"height of conductors from fig we got";
parameter Modelica.SIunits.Distance d=8"distance between conductors from fig we got";
parameter Modelica.SIunits.Distance j=8"distance between a'and c' from fig we got";
parameter Modelica.SIunits.Permittivity k=8.85e-12"permittivity of free space";
parameter Real w=314"a constant value";
parameter Real V1(final quantity="ElectricPotential", final unit="kV")=110"line voltage";
parameter Real Vn(final quantity="ElectricPotential", final unit="kV")=V/(3^0.5)"phase voltage";
parameter Modelica.SIunits.Distance i=(((j/2)^2)+((d-h)/2)^2)^(0.5)"distance between a and b";
parameter Modelica.SIunits.Distance f=((j^2)+(h^2))^0.5"distance between a'and a";
parameter Modelica.SIunits.Distance g=((7^2)+(4^2))^0.5"distance between b'and c";
parameter Real Cn(final quantity="Capacitance",final unit="microF/km")=(4*pi*k*1e9)/log((((i^2)*(g^2)*(j)*(h))/((r^3)*(f^2)*(d)))^(1/3))"Capacitance to neutral";
parameter Real Xn(final quantity="CapacitiveReactance",final unit="Ohms/km")=(w*Cn*1e-6)"Capacitive reactance to neutral";
parameter Modelica.SIunits.Current Cc_phase=Xn*Vn*1000"charging current/phase/km";
parameter Modelica.SIunits.Current Cc_conductor=Cc_phase/2"charging current/conductor/km";
//The answers may slightly vary due to rounding off values.
end Ex3_3;
