model Ex5_10
  constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion"; 
  parameter Real Length(final quantity="Length", final unit="km")=400"lenght of transmission line";
  parameter Modelica.SIunits.Frequency f=50"line freqency";
  parameter Real w=314"a constant";
  parameter Modelica.SIunits.Resistance r=0.035"line resistance/km/phase";
  parameter Real l(final quantity="Inductance",final unit="mH")=1.1"line inductance/km/phase";
  parameter Real c(final quantity="Capacitance",final unit="microF")=0.012"line capacitance/km/phase";
  parameter Real mod_Vs(final quantity="ElectricPotential", final unit="kV")=275"sending end voltage of transmission line"; 
parameter Real mod_Vr(final quantity="ElectricPotential", final unit="kV")=275"receiving end voltage of transmission line";
  parameter Modelica.SIunits.Resistance R=r*Length"total line resistnce";
  parameter Modelica.SIunits.Reactance X=l*1e-3*Length*w"total line reactance"; 
  parameter Modelica.SIunits.ComplexImpedance Z=Complex(R,X)"line impedance in complex form";
  parameter Modelica.SIunits.Impedance Z_abs = (Z.re ^ 2 + Z.im ^ 2) ^ 0.5"absolute value of  line impedance";
  parameter Real Z_arg(unit="degree") = atan(Z.im / Z.re) * R2D "angle of line impedance";
  parameter Real Y=w*c*1e-6*Length"line admittance";
  parameter Modelica.SIunits.ComplexAdmittance Y1=Complex((Y*cos(pi/2)),(Y*sin(pi/2)))"line admittance in complex form";
  parameter Modelica.SIunits.Admittance Y1_abs = (Y1.re ^ 2 + Y1.im ^ 2) ^ 0.5"absolute value of  line admittance";
  parameter Real Y1_arg(unit="degree") = atan(Y1.im / Y1.re) * R2D "angle of line admittance";  
  parameter Complex A=(1+(0.5*Y1*Z))"constant";
  parameter Real A_abs = (A.re ^ 2 + A.im ^ 2) ^ 0.5"absolute value of A";
  parameter Real A_arg(unit="degree") = atan(A.im / A.re) * R2D "angle of A";  
  parameter Complex B=Z"constant";
  parameter Real B_abs = (B.re ^ 2 + B.im ^ 2) ^ 0.5"absolute value of B";
  parameter Real B_arg(unit="degree") = atan(B.im / B.re) * R2D "angle of B";
parameter Real radius(final quantity="Power", final unit="MVA")=(mod_Vs*mod_Vr)/B_abs"radius of receiving end circle";
parameter Real Location(final quantity="Power", final unit="MVA")=(A_abs/B_abs)*(mod_Vr)^2"location of centre of receiving end circle";
parameter Real diff(unit="degree")=B_arg-A_arg"difference between angle of A and B";
//using 'radius', 'Location', 'diff' a circle diagram i.e fig-5.24 is drawn and from circle diagram it is seen that the rating of shunt reactor needed is 55MVA
//The answers may slightly vary due to rounding off values.
end Ex5_10;
