model Ex5_11
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real pf=0.85"power factor";
parameter Real mod_Vs(final quantity="ElectricPotential", final unit="kV")=275"sending end voltage of transmission line";
parameter Real mod_Vr(final quantity="ElectricPotential", final unit="kV")=275"receiving end voltage of transmission line"; 
parameter Complex A=Complex((0.93*cos(1.5*D2R)),(0.93*sin(1.5*D2R)))"constant";
parameter Real A_abs = (A.re ^ 2 + A.im ^ 2) ^ 0.5"absolute value of A";
parameter Real A_arg(unit="degree") = atan(A.im / A.re) * R2D "angle of A";
parameter Complex B=Complex((115*cos(77*D2R)),(115*sin(77*D2R)))"constant";
parameter Real B_abs = (B.re ^ 2 + B.im ^ 2) ^ 0.5"absolute value of B";
parameter Real B_arg(unit="degree") = atan(B.im / B.re) * R2D "angle of B";
parameter Real Location(final quantity="Power", final unit="MVA")=(A_abs/B_abs)*(mod_Vr)^2"location of centre of receiving end circle";
parameter Real diff(unit="degree")=B_arg-A_arg"difference between angle of A and B";
parameter Real pa(unit="degree")=acos(pf)*R2D"power factor angle"; 
//case a
parameter Real load(final quantity="Power", final unit="MW")=250"receiving end load";
parameter Real CR_P(final quantity="Power", final unit="MVA")=850"radius of receiving end circle";
parameter Real Vs_a(final quantity="ElectricPotential", final unit="kV")=(CR_P*B_abs)/mod_Vr"sending end voltage required";
//case b
parameter Real Vs_b(final quantity="ElectricPotential", final unit="kV")=295"sending end voltage";
parameter Real radius(final quantity="Power", final unit="MVA")=(Vs_b*mod_Vr)/B_abs"new radius of the circle diagram";
//After drawing the circle of radius obtained above we get Pmax from our graph
parameter Real Pmax(final quantity="Power", final unit="MW")=556"maximum delivered power";
//case c
parameter Real Ps(final quantity="Power", final unit="MVA/MVAR")=295"additional MVA drawn from the line";
//The answers may slightly vary due to rounding off values. 
end Ex5_11;
