model Ex5_14
parameter Real capacity(final quantity="ElectricPotential", final unit="kV")=400"capacity of the lines";
parameter Real line_a=4"number of lines when all lines are in service";
parameter Real line_b=3"number of lines when one line is out of service";
parameter Real phase=3"phase";
parameter Modelica.SIunits.Current I_line_a=1000"line current when all lines are in service";
parameter Modelica.SIunits.Current I_line_b=1333"line current when one line is out of service";
parameter Modelica.SIunits.Reactance x=50"line reactance";
parameter Real loss_a(final quantity="Power", final unit="MVAR")=(line_a*phase*(I_line_a^2)*x)/1e6"series reactive loss when all lines are in service";
parameter Real loss_b(final quantity="Power", final unit="MVAR")=(line_b*phase*(I_line_b^2)*x)/1e6"series reactive loss when one line is out of service";
parameter Real loss_aadditional(unit="%")=((loss_b-loss_a)/loss_a)*100"Additional series reactive loss";
//The answers may slightly vary due to rounding off values.
end Ex5_14;
