model Ex5_3
parameter Real Vs(final quantity="Power", final unit="kW")=2000"input power to the single-phase short circuit line";
parameter Real cosfi=0.8"real power factor";
parameter Real pf=cosfi"real power factor";
parameter Real sinfi=0.6"recative power factor";
parameter Modelica.SIunits.Resistance r=0.4"series resitance of line";
parameter Modelica.SIunits.Resistance x=0.4"series reactance of line";
parameter Modelica.SIunits.Voltage Vr=3000"load voltage";
parameter Modelica.SIunits.Impedance Z=((r^2)+(x^2))^0.5"series impedance";
parameter Modelica.SIunits.Power P=(Vs*1e3)/pf"Total power of the system";
parameter Modelica.SIunits.ActivePower P1=((Vs*1e3)/pf)*cosfi"Active power";
parameter Modelica.SIunits.ReactivePower P2=((Vs*1e3)/pf)*sinfi"reactive power";
//we have our equation as
//p^2=(I^2)*((vr^2)+(2*r*P1)+(2*x*P2))-(I^4)*((2*r^2)+(2*x^2)-Z^2)
//Rearranging this equation in the form of Shridhar Acharya we have our coefficient as follows:
parameter Real a=((2*(r^2))+(2*(x^2))-(Z^2));
parameter Real b=-((Vr^2)+(2*r*P1)+(2*x*P2));
parameter Real c=P^2;
parameter Modelica.SIunits.Current I=((-b)-(((b^2)-(4*a*c)))^0.5)/(2*a)"square of current passes through the line";
parameter Modelica.SIunits.Current I1=I^0.5"current passes through the line";
//we know I*cosfi=(Vs-r*(I1^2))/Vr
parameter Real cosfi_new=((Vs*1e3)-(r*(I1^2)))/(Vr*I1)"receiving end power factor";
parameter Real load_pr(final quantity="Power", final unit="kW")=(Vr*I1*cosfi_new)/1e3"Load";
parameter Real Vs_new(final quantity="ElectricPotential", final unit="kV")=Vs/(I1*pf)"Supply voltage";
//The answers may slightly vary due to rounding off values.
end Ex5_3;
