model Ex5_5
  constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Real Length(final quantity="Length", final unit="km")=300"lenght of transmission line";
  parameter Modelica.SIunits.Frequency f=50"line freqency";
  parameter Modelica.SIunits.Admittance Y=1e-3"total shunt admittance";
  parameter Real Sn(final quantity="Power", final unit="MW")=50"receiving end power";
  parameter Real pf=0.8"power factor";
  parameter Real load_v(final quantity="ElectricPotential", final unit="kV")=220"receiving end voltage";
  parameter Real fi=-acos(pf)"power factor angle, lagging so negative";
  parameter Modelica.SIunits.ComplexImpedance Z=Complex(40,125)"total series impedance";
  parameter Modelica.SIunits.Impedance Z_abs = (Z.re ^ 2 + Z.im ^ 2) ^ 0.5"absolute value of total series impedance";
  parameter Real Z_arg(unit="degree") = atan(Z.im / Z.re) * R2D "angle of total series impedance";
  parameter Modelica.SIunits.ComplexAdmittance Y1=Complex((Y*cos(pi/2)),(Y*sin(pi/2)))"line admittance";
  parameter Modelica.SIunits.Admittance Y1_abs = (Y1.re ^ 2 + Y1.im ^ 2) ^ 0.5"absolute value of line admittance";
  parameter Real Y1_arg(unit="degree") = atan(Y1.im / Y1.re) * R2D "angle of line admittance";
  parameter Complex Ir1=Complex(((Sn/((3^0.5)*pf*load_v))*cos(fi)),((Sn/((3^0.5)*pf*load_v))*sin(fi)))"receiving end current in kA";
  parameter Real Ir1_abs(final quantity="ElectricCurrent", final unit="kA") = (Ir1.re ^ 2 + Ir1.im ^ 2) ^ 0.5"absolute value of receiving end current";
  parameter Real Ir1_arg(unit="degree") = atan(Ir1.im / Ir1.re) * R2D "angle of receiving end current";
  parameter Complex Vr1=Complex(((load_v/(3^0.5))*cos(0)),(Y*sin(0)))"receiving end voltage in kV";
  parameter Real Vr1_abs(final quantity="ElectricPotential", final unit="kV") = (Vr1.re ^ 2 + Vr1.im ^ 2) ^ 0.5"absolute value of receiving end voltage";
  parameter Real Vr1_arg(unit="degree") = atan(Vr1.im / Vr1.re) * R2D "angle of receiving end voltage";
  //case a
  parameter Complex Vs=Vr1_abs+Ir1*Z"sending end voltage in kV using short circuit approximation";
  parameter Real Vs_abs(final quantity="ElectricPotential", final unit="kV") = (Vs.re ^ 2 + Vs.im ^ 2) ^ 0.5"absolute value of sending end voltage using short circuit approximation";
  parameter Real Vs_arg(unit="degree") = atan(Vs.im / Vs.re) * R2D "angle of sending end voltage using short circuit approximation";
  parameter Real Vs_line(final quantity="ElectricPotential", final unit="kV")=Vs_abs*(3^0.5)"sending end line voltage using short circuit approximation";
  parameter Complex I_s=Ir1"sending end current in kA";
  parameter Real pf_s=cos((-Ir1_arg+Vs_arg)*D2R)"sending end power factor using short circuit approximation";
  parameter Real p(final quantity="Power", final unit="MW")=(3^0.5)*Vs_line*Ir1_abs*pf_s"sending end power using short circuit approximation";
  //case b
  parameter Complex A=(1+(0.5*Y1*Z))"constant";
  parameter Real A_abs = (A.re ^ 2 + A.im ^ 2) ^ 0.5"absolute value of A";
  parameter Real A_arg(unit="degree") = atan(A.im / A.re) * R2D "angle of A";
  parameter Complex B=Z"constant";
  parameter Real B_abs = (B.re ^ 2 + B.im ^ 2) ^ 0.5"absolute value of B";
  parameter Real B_arg(unit="degree") = atan(B.im / B.re) * R2D "angle of B";
  parameter Complex C=Y1*(1+(0.25*Y1*Z))"constant";
  parameter Real C_abs = (C.re ^ 2 + C.im ^ 2) ^ 0.5"absolute value of C";
  parameter Real C_arg(unit="degree") = atan(C.im / C.re) * R2D "angle of C";
  parameter Real C_arg1(unit="degree")=C_arg+180"modified angle of C";
  parameter Complex Vs1=A*Vr1_abs+Z*Ir1"sending end voltage using nominal pi method";
  parameter Real Vs1_abs(final quantity="ElectricPotential", final unit="kV") = (Vs1.re ^ 2 + Vs1.im ^ 2) ^ 0.5"absolute value of sending end voltage using nominal pi method" ;
  parameter Real Vs1_arg(unit="degree") = atan(Vs1.im / Vs1.re) * R2D "angle of sending end voltage using nominal pi method";
  parameter Real Vs1_line(final quantity="ElectricPotential", final unit="kV")=Vs1_abs*(3^0.5)"sending end line voltage using nominal pi method" ;
  parameter Complex Is=(C*(load_v/(3^0.5)))+A*Ir1"sending end current using nominal pi method";
  parameter Real Is_abs(final quantity="ElectricCurrent", final unit="kA") = (Is.re ^ 2 + Is.im ^ 2) ^ 0.5"absolute value of sending end current using nominal pi method";
  parameter Real Is_arg(unit="degree") = atan(Is.im / Is.re) * R2D "angle of sending end current using nominal pi method";
  parameter Real pf_se=cos((Is_arg-Vs1_arg)*D2R)"sending end power factor using nominal pi method";
  parameter Real p_se(final quantity="Power", final unit="MW")=(3^0.5)*Vs1_line*Is_abs*pf_se"sending end power using nominal pi method";
  //case c
   parameter Complex yl=(Y1*Z)^0.5"cosh=(al+jBl) using exact transmission line equations";
  parameter Real yl_abs = (yl.re ^ 2 + yl.im ^ 2) ^ 0.5"absolute value of yl using exact transmission line equations";
  parameter Real yl_arg(unit="degree") = atan(yl.im / yl.re) * R2D "angle of  yl using exact transmission line equations";
  parameter Real Bl(unit="degree")=(yl.im)*R2D"angle Bl";
  parameter Complex e1=Complex((exp(yl.re)*cos(Bl*D2R)),((exp(yl.re)*sin(Bl*D2R))))"a complex value using exact transmission line equations";
  parameter Complex e2=Complex((exp(-yl.re)*cos(-Bl*D2R)),((exp(-yl.re)*sin(-Bl*D2R))))"a complex value using exact transmission line equations";
  parameter Complex coshyl=0.5*(e1+e2)"value of cosh(yl) using exact transmission line equations";
  parameter Real coshyl_abs = (coshyl.re ^ 2 + coshyl.im ^ 2) ^ 0.5"absolute value of cosh(yl) using exact transmission line equations";
  parameter Real coshyl_arg(unit="degree") = atan(coshyl.im / coshyl.re) * R2D "angle of cosh(yl) using exact transmission line equations";
  parameter Complex sinhyl=0.5*(e1-e2)"value of sin(yl) using exact transmission line equations";
  parameter Real sinhyl_abs = (sinhyl.re ^ 2 + sinhyl.im ^ 2) ^ 0.5"absolute value of sin(yl) using exact transmission line equations";
  parameter Real sinhyl_arg(unit="degree") = atan(sinhyl.im / sinhyl.re) * R2D "angle of sin(yl) using exact transmission line equations";
  parameter Modelica.SIunits.ComplexImpedance Zc=(Z/Y1)^0.5"line impedance using exact transmission line equations ";
  parameter Modelica.SIunits.Impedance Zc_abs = (Zc.re ^ 2 + Zc.im ^ 2) ^ 0.5"absolute value of line impedance using exact transmission line equations";
  parameter Real Zc_arg(unit="degree") = atan(Zc.im / Zc.re) * R2D "angle of line impedance using exact transmission line equations";
  parameter Complex A1=coshyl"constant";
  parameter Real A1_abs = (A1.re ^ 2 + A1.im ^ 2) ^ 0.5"absolute value of A1";
  parameter Real A1_arg(unit="degree") = atan(A1.im / A1.re) * R2D "angle of A1";
  parameter Complex D1=A1"constant";
  parameter Complex B1=Zc*sinhyl"constant";
  parameter Real B1_abs = (B1.re ^ 2 + B1.im ^ 2) ^ 0.5"absolute value of B1";
  parameter Real B1_arg(unit="degree") = atan(B1.im / B1.re) * R2D  "angle of B1";
  parameter Complex Vs2=A1*Vr1_abs+B1*Ir1"sending end voltage in kV using exact transmission line equations";
  parameter Real Vs2_abs(final quantity="ElectricPotential", final unit="kV") = (Vs2.re ^ 2 + Vs2.im ^ 2) ^ 0.5"absolute value of sending end voltage in kV using exact transmission line equations ";
  parameter Real Vs2_arg(unit="degree") = atan(Vs2.im / Vs2.re) * R2D "angle of sending end voltage in kV using exact transmission line equations";
  parameter Real Vs2_line(final quantity="ElectricPotential", final unit="kV")=Vs2_abs*(3^0.5)"sending end line voltage using exact transmission line equations";  
  parameter Complex C1=(1/Zc)*sinhyl"constant";
  parameter Real C1_abs = (C1.re ^ 2 + C1.im ^ 2) ^ 0.5"absolute value of C1";
  parameter Real C1_arg(unit="degree") = atan(C1.im / C1.re) * R2D "angle of C1";
  parameter Real C1_arg1(unit="degree")=C1_arg+180"modified angle of C1";
  parameter Complex Is1=C1*Vr1_abs+A*Ir1"sending end current in kA using exact transmission line equations";
  parameter Real Is1_abs(final quantity="ElectricCurrent", final unit="kA") = (Is1.re ^ 2 + Is1.im ^ 2) ^ 0.5"absolute value of sending end current in kA using exact transmission line equations";
  parameter Real Is1_arg(unit="degree") = atan(Is1.im / Is1.re) * R2D "angle of sending end current in kA using exact transmission line equations";
  parameter Real pf1_se=cos((Is1_arg-Vs1_arg)*D2R)"sending end power factor using exact transmission line equations";
  parameter Real p2_se(final quantity="Power", final unit="MW")=(3^0.5)*Vs2_line*Is_abs*pf_se"sending end power using exact transmission line equations";
  // case d
  parameter Complex A2=A"constant";
  parameter Complex D2=A2"constant";
  parameter Complex B2=Z+((1/6)*(Y1*(Z^2)))"constant";
  parameter Real B2_abs = (B2.re ^ 2 + B2.im ^ 2) ^ 0.5"absolute value of B2";
  parameter Real B2_arg(unit="degree") = atan(B2.im / B2.re) * R2D "angle of B2";
  parameter Complex C2=Y1*(1+((1/6)*(Y1*Z)))"constant";
  parameter Real C2_abs = (C2.re ^ 2 + C2.im ^ 2) ^ 0.5"absolute value of C2";
  parameter Real C2_arg(unit="degree") = atan(C2.im / C2.re) * R2D "angle of C2";
  parameter Real C2_arg1(unit="degree")=C1_arg+180"modified angle of C2";
  parameter Complex Vs3=A2*Vr1_abs+B2*Ir1"sending end voltage in kV using approximation";
  parameter Real Vs3_abs(final quantity="ElectricPotential", final unit="kV") = (Vs3.re ^ 2 + Vs3.im ^ 2) ^ 0.5"absolute value of sending end voltage using approximation";
  parameter Real Vs3_arg(unit="degree") = atan(Vs3.im / Vs3.re) * R2D "angle of sending end voltage using approximation";
  parameter Real Vs3_line(final quantity="ElectricPotential", final unit="kV")=Vs3_abs*(3^0.5)"sending end line voltage using approximation";
  parameter Complex Is2=C2*Vr1_abs+A2*Ir1"sending end current in kA using approximation";
  parameter Real Is2_abs(final quantity="ElectricCurrent", final unit="kA") = (Is2.re ^ 2 + Is2.im ^ 2) ^ 0.5"absolute value of sending end current using approximation";
  parameter Real Is2_arg(unit="degree") = atan(Is2.im / Is2.re) * R2D "angle of sending end current using approximation";
  parameter Real pf2_se=cos((Is2_arg-Vs1_arg)*D2R)"sending end power factor using approximation";
  parameter Real p3_se(final quantity="Power", final unit="MW")=(3^0.5)*Vs3_line*Is2_abs*pf_se"sending end power using approximation";
  //The answers may slightly vary due to rounding off values.
end Ex5_5;
