model Ex5_6
  constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979  in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Real Length(final quantity="Length", final unit="km")=400"lenght of transmission line";
  parameter Modelica.SIunits.Frequency f=50"line freqency";
  parameter Modelica.SIunits.Resistance r=0.125"line resistance/km";
  parameter Modelica.SIunits.Reactance x=0.4"line reactance/km";
  parameter Complex x1=Complex(0,x)"line reactance in ohm/km in complex form";
  parameter Modelica.SIunits.Resistance y=2.8*1e-6"line admittance/km";
  parameter Modelica.SIunits.ComplexImpedance y1=Complex(0,y)"line admittance/km in complex form";
  parameter Real load_v(final quantity="ElectricPotential", final unit="kV")=220"voltage at sending end";
  parameter Modelica.SIunits.Resistance  R=r*Length"total line resistance";
  parameter Modelica.SIunits.Reactance X=x*Length"total line reactance";
  parameter Modelica.SIunits.Resistance Y=y*Length"total line admittance";
  parameter Modelica.SIunits.ComplexImpedance Y1=Complex((Y*cos(pi/2)),(Y*sin(pi/2)))"total line admittance in complex form";
  parameter Modelica.SIunits.Impedance Y1_abs = (Y1.re ^ 2 + Y1.im ^ 2) ^ 0.5"absolute value of total line admittance";
  parameter Real Y1_arg(unit="degree") = atan(Y1.im / Y1.re) * R2D "angle of total line admittance";
  parameter Modelica.SIunits.ComplexImpedance Z=Complex(R,X)"total line impedance";
  parameter Modelica.SIunits.Impedance Z_abs = (Z.re ^ 2 + Z.im ^ 2) ^ 0.5"absolute value of total line impedance";
  parameter Real Z_arg(unit="degree") = atan(Z.im / Z.re) * R2D "angle of total line impedance";
  parameter Complex YZ=Y1*Z"product of total line admittance and impedance";
  parameter Real YZ_abs = (YZ.re ^ 2 + YZ.im ^ 2) ^ 0.5"absolute value of product of total line admittance and impedance";
  parameter Real YZ_arg(unit="degree") = atan(YZ.im / YZ.re) * R2D "angle of product of total line admittance and impedance";
  parameter Real YZ_arg1(unit="degree")=YZ_arg+180"modified angle of product of total line admittance and impedance";
  //case a
  parameter Complex A=(1+(0.5*Y1*Z))"constant A";
  parameter Real A_abs = (A.re ^ 2 + A.im ^ 2) ^ 0.5"absolute value of constant A";
  parameter Real A_arg(unit="degree") = atan(A.im / A.re) * R2D "angle of constant A";
  parameter Complex C=Y1*(1+((1/6)*(Y1*Z)))"constant C";
  parameter Real C_abs = (C.re ^ 2 + C.im ^ 2) ^ 0.5"absolute value of constant C";
  parameter Real C_arg(unit="degree") = atan(C.im / C.re) * R2D "angle of constant C";
  parameter Real C_arg1(unit="degree")=C_arg+180"modified angle of constant C";
  parameter Real V_line(final quantity="ElectricPotential", final unit="kV")=load_v/A_abs"receiving end line voltage at no load";
  parameter Modelica.SIunits.Current Is=C_abs*(V_line/(3^0.5))*1e3"sending end current at no load";
  //case b
  parameter Real Vr(final quantity="ElectricPotential", final unit="kV")=235"maximum permissible no-load receiving end voltage";
  parameter Real A1_abs=load_v/Vr"mod A value";
  parameter Real L(final quantity="Length", final unit="km")=((1-A1_abs)/(0.5*x1.im*y1.im))^0.5"the maximum permisible length";  
  //case c
  parameter Real Vr1(final quantity="ElectricPotential", final unit="kV")=250"maximum permissible no-load receiving end voltage";
  parameter Real A2_abs=load_v/Vr1"mod A value";
  parameter Modelica.SIunits.Frequency F1=((((1-A2_abs)*(50^2))/(0.5*Y1_abs*X))^0.5)"maximum permissible frequency"; 
   //The answers may slightly vary due to rounding off values.
end Ex5_6;
