model Ex6_11
OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1.04, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-48, 32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {52, 34}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1.04, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {6, -32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21 annotation(
    Placement(visible = true, transformation(origin = {-47, 75}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22 annotation(
    Placement(visible = true, transformation(origin = {51, 73}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order23 annotation(
    Placement(visible = true, transformation(origin = {9, -71}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1 annotation(
    Placement(visible = true, transformation(origin = {2, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2 annotation(
    Placement(visible = true, transformation(origin = {-48, 4}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3 annotation(
    Placement(visible = true, transformation(origin = {52, 4}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {-76, 66}, extent = {{-6, -6}, {6, 6}}, rotation = 180)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2 annotation(
    Placement(visible = true, transformation(origin = {78, 66}, extent = {{-6, 6}, {6, -6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant3 annotation(
    Placement(visible = true, transformation(origin = {-30, -58}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
 
  constant Real pi = 2 * Modelica.Math.asin(1.0);   // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
 //case a : Using 'Decoupled NR method'
  //using equations 6.86a,b,c we have the following values
  parameter Real V1(unit = "pu")=1.04"bus 1 voltage";
  parameter Real V2(unit = "pu")=1"bus 2 voltage";
  parameter Real V3(unit = "pu") = 1.04 "voltage of bus 3";
  parameter Real Q2(unit = "pu") = 1 "reactive power at bus2";
  parameter Real B23 = 11.764"imaginary part of Y_bus[2,3]of Y_bus from Ex6_10";
  parameter Real B22 = -23.508"imaginary part of Y_bus[2,2]of Y_bus from Ex6_10";
  parameter Real B33 = -23.508"imaginary part of Y_bus[3,3]of Y_bus from Ex6_10";
  parameter Real B31 = 11.764"imaginary part of Y_bus[3,1]of Y_bus from Ex6_10";
  parameter Real B32 = B23"imaginary part of Y_bus[3,2]of Y_bus from Ex6_10";
  parameter Real H22_0 = 24.47"diagonal element of H matrix";
  parameter Real H23_0 = 1.04 * (-B23)"off-diagonal element of H matrix";
  parameter Real H32_0=H23_0"off-diagonal element of H matrix";
  parameter Real H33_0 = (-B31 * V3 ^ 2) - B32 * V3 ^ 2 - B33 * V3 ^ 2 - B33 * 1.04 ^ 2"diagonal element of H matrix";
  parameter Real L22_0 = Q2 - B22"diagonal element of L matrix";
  parameter Real delP2(unit = "pu") = 0.73"power residual from Ex6_10" ;
  parameter Real delP3(unit = "pu") = -1.62"power residual from Ex6_10";
  parameter Real [2,1]P={{delP2},{delP3}}"power residuals in matrix form";
  parameter Real [2,2]H={{H22_0,H23_0},{H32_0,H33_0}}"Jacobian element in matrix form";
  parameter Real [2,2]H_inv=Modelica.Math.Matrices.inv(H)"inverse of Jacobian element in matrix form";
  parameter Real [2,1]D=H_inv*P"product of inverse of H matrix with P matrix";
  parameter Real del_delta2_0(unit = "radian")=D[1,1]"change in voltage angle of bus2";
  parameter Real del_delta2_0_new(unit = "degree")=D[1,1]*R2D"change in voltage angle of bus2";
  parameter Real del_delta3_0(unit = "radian")=D[2,1]"change in voltage angle of bus3";
  parameter Real del_delta3_0_new(unit = "degree")=D[2,1]*R2D"change in voltage angle of bus3";
  parameter Real delta2_1(unit = "degree")=(0+del_delta2_0_new)"voltage angle of bus2";
  parameter Real delta3_1(unit = "degree")=(0+del_delta3_0_new)"voltage angle of bus3";
  //Using elements of Y bus from Ex6_10 we have
  parameter Real Y21=12.13"off-diagonal element of Y_bus matrix";
  parameter Real Y22=24.23"diagonal element of Y_bus matrix";
  parameter Real Y23=12.13"off-diagonal element of Y_bus matrix";
  parameter Real theta21(unit = "degree")=104.04"angle of Y_bus[2,1]of Y_bus from Ex6_10";
  parameter Real theta22(unit = "degree")=-75.95"angle of Y_bus[2,2]of Y_bus from Ex6_10";
  parameter Real theta23(unit = "degree")=104.04"angle of Y_bus[2,3]of Y_bus from Ex6_10";
  parameter Real Q2_0(unit = "pu")=(-V2*V1*Y21*sin(theta21*D2R+0-delta2_1*D2R))-((V2^2)*Y22*sin(theta22*D2R))-V2*V3*Y23*sin(theta23*D2R+delta2_1*D2R-delta3_1*D2R)"reactive power at bus2";
  parameter Real delQ2_0(unit = "pu")=1-Q2_0"change in value of reactive power at bus2";
  parameter Real delV2_0(unit = "pu")=delQ2_0/L22_0"change in voltage at bus2";
  parameter Real V2_1(unit = "pu")=V2+delV2_0"voltage at bus2";
 //case b: using 'FDLF method'
  parameter Real P1_1=delP2/V2"value of (delP2/V2)";
  parameter Real P1_2=delP3/V3"value of (delP3/V3)";
  parameter Real [2,1]P1={{P1_1},{P1_2}}"derivations of change in active power with respect to voltage in matrix form";
  parameter Real [2,2]B={{-B22,-B23},{-B23,-B33}}"susceptance matrix";  
  parameter Real [2,2]B_inv=Modelica.Math.Matrices.inv(B)"inverse of susceptance matrix";   
  parameter Real [2,1]D1=B_inv*P1"product of inverse of B matrix with P1 matrix";
  parameter Real del_delta2_0_b(unit = "radian")=D1[1,1]"change in voltage angle of bus2";
  parameter Real del_delta3_0_b(unit = "radian")=D1[2,1]"change in voltage angle of bus3";
  parameter Real delta2_1_b(unit = "radian")=0+del_delta2_0_b"voltage angle of bus2";
  parameter Real delta3_1_b(unit = "radian")=0+del_delta3_0_b"voltage angle of bus3";
  parameter Real delV2_0_b(unit = "pu")=delQ2_0/(-B22)"change in voltage at bus2";
  parameter Real V2_1_b(unit = "pu")=V2+delV2_0_b"voltage at bus2";
inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-171, 75}, extent = {{-17, -17}, {17, 17}}, rotation = 0)));  equation
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{52, 34}, {54, 34}, {54, 48}, {78, 48}, {78, 60}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{12, 42}, {44, 42}, {44, 34}, {52, 34}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.p) annotation(
    Line(points = {{52, 34}, {52, 13}}, color = {0, 0, 255}));
  connect(order22.p, bus2.p) annotation(
    Line(points = {{51, 66}, {51, 34}, {52, 34}}, color = {0, 0, 255}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{47.5, 81.4}, {45.5, 81.4}, {45.5, 87.4}, {35.5, 87.4}, {35.5, 77.4}, {43.5, 77.4}, {43.5, 77.4}}, color = {0, 0, 127}));
  connect(order22.vf, order22.vf0) annotation(
    Line(points = {{54.5, 81.4}, {54.5, 81.4}, {54.5, 87.4}, {64.5, 87.4}, {64.5, 77.4}, {58.5, 77.4}, {58.5, 77.4}}, color = {0, 0, 127}));
  connect(bus1.p, voltDependant1.p) annotation(
    Line(points = {{-48, 32}, {-52, 32}, {-52, 50}, {-76, 50}, {-76, 60}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.n) annotation(
    Line(points = {{6, -32}, {6, -20}, {-48, -20}, {-48, -4}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.n) annotation(
    Line(points = {{6, -32}, {12, -32}, {12, -20}, {52, -20}, {52, -5}}, color = {0, 0, 255}));
  connect(bus3.p, order23.p) annotation(
    Line(points = {{6, -32}, {10, -32}, {10, -64}}, color = {0, 0, 255}));
  connect(voltDependant3.p, bus3.p) annotation(
    Line(points = {{-30, -52}, {-30, -44}, {6, -44}, {6, -32}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-48, 32}, {-44, 32}, {-44, 42}, {-6, 42}, {-6, 42}}, color = {0, 0, 255}));
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-50, 84}, {-50, 84}, {-50, 90}, {-60, 90}, {-60, 80}, {-54, 80}, {-54, 80}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-44, 84}, {-44, 84}, {-44, 90}, {-34, 90}, {-34, 80}, {-40, 80}, {-40, 80}}, color = {0, 0, 127}));
  connect(order23.pm, order23.pm0) annotation(
    Line(points = {{12, -80}, {12, -80}, {12, -86}, {20, -86}, {20, -76}, {16, -76}, {16, -76}}, color = {0, 0, 127}));
  connect(order23.vf, order23.vf0) annotation(
    Line(points = {{6, -80}, {6, -80}, {6, -86}, {-2, -86}, {-2, -76}, {2, -76}, {2, -76}}, color = {0, 0, 127}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-46, 68}, {-48, 68}, {-48, 32}, {-48, 32}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.p) annotation(
    Line(points = {{-48, 32}, {-48, 13}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values.
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex6_11;
