model Ex6_13
OpenIPSL.Electrical.Machines.PSAT.Order2 order22 annotation(
    Placement(visible = true, transformation(origin = {56, 60}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order23 annotation(
    Placement(visible = true, transformation(origin = {-50, 58}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1, angle_0 = 0, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-52, 20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {56, 20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {-52, -26}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2 annotation(
    Placement(visible = true, transformation(origin = {56, -26}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0.01, X = 0.05) annotation(
    Placement(visible = true, transformation(origin = {2, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Complex Y = Complex(0, 0.01) "shunt admittance in pu";
  parameter Complex Y1 = Complex(0, 0.005) "tollerance in pu";
  parameter Complex Z = Complex(pwLine1.R, pwLine1.X) "series impedance in pu";
  parameter Complex Y_series = 1 / Z "series admittance in pu";
  parameter Real Y_series_abs(unit = "pu") = (Y_series.re ^ 2 + Y_series.im ^ 2) ^ 0.5"absolue value of series admittance";
  parameter Real Y_series_arg(unit = "degree") = atan(Y_series.im / Y_series.re) * R2D "angle of series admittance";
  parameter Real Y_series_arg1(unit = "degree") = Y_series_arg + 180"angle of series admittance";
  parameter Complex Y12 = -Y_series "each off-diagonal term of Y bus in pu";
  parameter Complex Y21 = Y12 "each off-diagonal term of Y bus in pu";
  parameter Complex Y11 = Y_series + Y1 "each self term of Y bus in pu";
  parameter Complex Y22 = Y11 "each self term of Y bus in pu";
  parameter Complex[2, 2] Y_bus = {{Y11, Y12}, {Y21, Y22}}"complex bus admittances in matrix form";
  //using eqn (v) we can evaluate the range of Q2 as follows
  parameter Real a = -4.94 * 1e-3;
  parameter Real b = 76.91;
  parameter Real c = 384.78;
  parameter Real Q2_1(unit = "pu") = ((-b) + (b ^ 2 - 4 * a * c) ^ 0.5) / (2 * a) "allowing (+) sign,reactive power of bus2";
  parameter Real Q2_2(unit = "pu") = ((-b) - (b ^ 2 - 4 * a * c) ^ 0.5) / (2 * a) "allowing (-) sign,reactive power of bus2";
  parameter Real Q2_accepted_a(unit = "pu")=Q2_1"range of reactive power of bus2,negative power is accepted as load act as sink of power";
  //Obtaining the range of P2:
  //case a
  parameter Real Q2_a(unit = "pu") = -2 "reactive power of bus2 from equation (iv)";
  //extracting different coefficients from eqn (iv) for applying Shridhar Acharya formula in order to solve  for P2 we get
  parameter Real a1 = -0.962;
  parameter Real b1 = 0.384 * Q2_a + 3.844;
  parameter Real c1 = -(0.0296 * Q2_a ^ 2 - 19.22 * Q2_a - 96.138);
  parameter Real P2_a_1(unit = "pu") = ((-b1) + (b1 ^ 2 - 4 * a1 * c1) ^ 0.5) / (2 * a1) "allowing (+) sign, real power of bus2";
  parameter Real P2_a_2(unit = "pu") = ((-b1) - (b1 ^ 2 - 4 * a1 * c1) ^ 0.5) / (2 * a1) "allowing (-) sign, real power of bus2";
  parameter Real P2_accepted_a(unit = "pu")=P2_a_1"range of real power of bus2,negative power is accepted as load act as sink of power";  
  //case b
  parameter Real Q2_b(unit = "pu") = 0 "reactive power of bus2 from equation (iv)";
  //extracting different coefficients from eqn (iv) for applying Shridhar Acharya formula in order to solve  for P2 we get
  parameter Real a2 = -0.962;
  parameter Real b2 = 0.384 * Q2_b + 3.844;
  parameter Real c2 = -(0.0296 * Q2_b ^ 2 - 19.22 * Q2_b - 96.138);
  parameter Real P2_b_1(unit = "pu") = ((-b2) + (b2 ^ 2 - 4 * a2 * c2) ^ 0.5) / (2 * a2) "allowing (+) sign, real power of bus2";
  parameter Real P2_b_2(unit = "pu") = ((-b2) - (b2 ^ 2 - 4 * a2 * c2) ^ 0.5) / (2 * a2) "allowing (-) sign, real power of bus2";
  parameter Real P2_accepted_b(unit = "pu")=P2_b_1"range of real power of bus2,negative power is accepted as load act as sink of power";
  //case c
  parameter Real Q2_c(unit = "pu") = 2 "reactive power of bus2 from equation (iv)";
  //extracting different coefficients from eqn (iv) for applying Shridhar Acharya formula in order to solve  for P2 we get
  parameter Real a3 = -0.962;
  parameter Real b3 = 0.384 * Q2_c + 3.844;
  parameter Real c3 = -(0.0296 * Q2_c ^ 2 - 19.22 * Q2_c - 96.138);
  parameter Real P2_c_1(unit = "pu") = ((-b3) + (b3 ^ 2 - 4 * a3 * c3) ^ 0.5) / (2 * a3) "allowing (+) sign, real power of bus2";
  parameter Real P2_c_2(unit = "pu") = ((-b3) - (b3 ^ 2 - 4 * a3 * c3) ^ 0.5) / (2 * a3) "allowing (-) sign, real power of bus2";
  parameter Real P2_accepted_c(unit = "pu")=P2_c_1"range of real power of bus2,negative power is accepted as load act as sink of power";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {2, 65}, extent = {{-14, -15}, {14, 15}}, rotation = 0)));
equation
  connect(order22.vf, order22.vf0) annotation(
    Line(points = {{61, 72}, {61, 72}, {61, 80}, {75, 80}, {75, 68}, {67, 68}, {67, 68}}, color = {0, 0, 127}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{51, 72}, {49, 72}, {49, 80}, {35, 80}, {35, 68}, {45, 68}, {45, 68}}, color = {0, 0, 127}));
  connect(order22.p, bus2.p) annotation(
    Line(points = {{56, 50}, {56, 20}}, color = {0, 0, 255}));
  connect(order23.pm, order23.pm0) annotation(
    Line(points = {{-54, 70}, {-56, 70}, {-56, 80}, {-70, 80}, {-70, 66}, {-60, 66}, {-60, 66}}, color = {0, 0, 127}));
  connect(order23.vf, order23.vf0) annotation(
    Line(points = {{-44, 70}, {-46, 70}, {-46, 80}, {-32, 80}, {-32, 66}, {-40, 66}, {-40, 66}, {-38, 66}}, color = {0, 0, 127}));
  connect(bus2.p, pwLine1.n) annotation(
    Line(points = {{56, 20}, {52, 20}, {52, 10}, {12, 10}, {12, 10}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-52, 20}, {-46, 20}, {-46, 10}, {-6, 10}, {-6, 10}}, color = {0, 0, 255}));
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{56, 20}, {56, 20}, {56, -16}, {56, -16}}, color = {0, 0, 255}));
  connect(bus1.p, voltDependant1.p) annotation(
    Line(points = {{-52, 20}, {-52, 20}, {-52, -16}, {-52, -16}}, color = {0, 0, 255}));
  connect(order23.p, bus1.p) annotation(
    Line(points = {{-50, 48}, {-52, 48}, {-52, 20}, {-52, 20}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values. 
end Ex6_13;
