model Ex7_1
/*case a
From equation 7.4 we get
parameter Real H_Pg=(a/Pg)+b+c*Pg"heat rate";
substituting measured values of H(Pg)at different ratings we get
(a/25)+b+(c*25)=10;
(a/40)+b+(c*40)=9;
(a/100)+b+(c*100)=8;
solving these equations we have
*/
parameter Real  a=1000/9"a coefficient";
parameter Real b=40/9"a coefficient";
parameter Real c=2/45"a coefficient"; 
/*equations of F_Pg and C_Pg are as follows
parameter Real F_Pg=a+b+c*Pg"fuel input rate in MKcal/h"; 
parameter Real C_Pg=2*F_Pg"fuel cost in Rs/h";
*/
//case b
parameter Real Pg1(final quantity="Power", final unit="MW")=25"at 25% rating";
parameter Real F_Pg1(unit = "MKcal/h")=a+b*Pg1+c*(Pg1^2)"fuel input rate at 25% rating"; 
parameter Real C_Pg1(unit = "Rs/h")=2*F_Pg1"fuel cost at 25% rating";
parameter Real Pg2(final quantity="Power", final unit="MW")=40"at 40% rating";
parameter Real F_Pg2(unit = "MKcal/h")=a+b*Pg2+c*(Pg2^2)"fuel input rate at 40% rating"; 
parameter Real C_Pg2(unit = "Rs/h")=2*F_Pg2"fuel cost at 40% rating";
parameter Real Pg3(final quantity="Power", final unit="MW")=100"at 100% rating";
parameter Real F_Pg3(unit = "MKcal/h")=a+b*Pg3+c*(Pg3^2)"fuel input rate at 100% rating"; 
parameter Real C_Pg3(unit = "Rs/h")=2*F_Pg3"fuel cost at 100% rating";
//case c
parameter Real IC1(unit = "Rs/MWh")=8.889+0.1778*Pg1"incremental cost for 25% rating";
parameter Real IC2(unit = "Rs/MWh")=8.889+0.1778*Pg2"incremental cost for 40% rating";
parameter Real IC3(unit = "Rs/MWh")=8.889+0.1778*Pg3"incremental cost for 100% rating";
//case d
parameter Real IC(unit = "Rs/MWh")=IC3"incremental cost for 100% rating";
parameter Real del_Pg(final quantity="Power", final unit="MW")=1"increment in output power";
parameter Real cost(unit = "Rs/h")=C_Pg3+IC*del_Pg"approximate cost at 101 MW";
//we can also calculate the cost by using different formula as follows
parameter Real Pg4(final quantity="Power", final unit="MW")=101"at 101% rating";
parameter Real F_Pg4(unit = "MKcal/h")=a+b*Pg4+c*(Pg4^2)"fuel input rate at 101% rating"; 
parameter Real C_Pg4(unit = "Rs/h")=2*F_Pg4"fuel cost at 101% rating";
//The answers may slightly vary due to rounding off values.
end Ex7_1;
