model Ex7_6
//In order to solve 2 equations to obtain the values of P_G1 and P_G2 we use the formula of Shridhar Acharya and calculated values of the parameters are assigned as follows
//case a:
parameter Real load(final quantity="Power", final unit="MW")=237.04"total load at bus2";
parameter Real A=0.00004;
parameter Real B=-0.06;
parameter Real C=13.4816;
parameter Real P_G1(final quantity="Power", final unit="MW")=(-B-((B^2)-4*A*C)^0.5)/(2*A)"optimum generation of plant1 when losses are included but not coordinated";
parameter Real P_G2(final quantity="Power", final unit="MW")=(0.001*(P_G1^2))-P_G1+load"optimum generation of plant2 when losses are included but not coordinated";
//case b:
// Using the values of P_G1 and P_G2 from the previous problem i.e. Ex_5
parameter Real P_G1_b(final quantity="Power", final unit="MW")=128.57"optimum generation of plant1 when losses are included and are also coordinated";
parameter Real P_G2_b(final quantity="Power", final unit="MW")=125"optimum generation of plant2 when losses are included and are also coordinated";
parameter Real P_G1_min(final quantity="Power", final unit="MW")=P_G1_b"minimum value of optimum generation of plant1";
parameter Real P_G1_max(final quantity="Power", final unit="MW")=P_G1"maximum value of optimum generation of plant1";
parameter Real P_G2_min(final quantity="Power", final unit="MW")=P_G2_b"minimum value of optimum generation of plant2";
parameter Real P_G2_max(final quantity="Power", final unit="MW")=P_G2"maximum value of optimum generation of plant2";
// load on plant 1
parameter Real cost_max_1(unit = "Rs/h")=(0.01*(P_G1_max^2))+(16*P_G1_max)"maximum cost on plant1";
parameter Real cost_min_1(unit = "Rs/h")=(0.01*(P_G1_min^2))+(16*P_G1_min)"minimum cost on plant1";
parameter Real cost_1(unit = "Rs/h")=cost_max_1-cost_min_1"saving of fuel cost at plant1 due to loss coordination";
// load on plant 2
parameter Real cost_max_2(unit = "Rs/h")=(0.02*(P_G2_max^2))+(20*P_G2_max)"maximum cost on plant2";
parameter Real cost_min_2(unit = "Rs/h")=(0.02*(P_G2_min^2))+(20*P_G2_min)"minimum cost on plant2";
parameter Real cost_2(unit = "Rs/h")=cost_max_2-cost_min_2"saving of fuel cost at plant1 due to loss coordination";
parameter Real net_saving(unit = "Rs/h")=cost_1+cost_2"net saving achieved by coordinating losses";
//The answers may slightly vary due to rounding off values.
end Ex7_6;
