model Ex7_7
  constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Complex Ia=Complex(2,-0.5)"current flows through branch a in pu";
  parameter Complex Ib=Complex(1.6,-0.4)"current flows through branch b in pu";
  parameter Complex Ic=Complex(1,-0.25)"current flows through branch c in pu";
  parameter Complex Id=Complex(3.6,-0.9)"current flows through branch d in pu";
  parameter Complex Za=Complex(0.015,0.06)"impedance of branch a in pu";
  parameter Complex Zb=Complex(0.015,0.06)"impedance of branch b in pu";
  parameter Complex Zc=Complex(0.01,0.04)"impedance of branch c in pu";
  parameter Complex Zd=Complex(0.01,0.04)"impedance of branch d in pu";
  parameter Complex I1=Id/(Ic+Id)"current from plant1";
  parameter Complex I2=Ic/(Ic+Id)"current from plant2";
  parameter Real Ma1=1"current distribution factor";
  parameter Real Mb1=-I2.re"current distribution factor";
  parameter Real Mc1=I2.re"current distribution factor";
  parameter Real Md1=I1.re"current distribution factor";
  parameter Real Ma2=0"current distribution factor";
  parameter Real Mb2=Md1"current distribution factor";
  parameter Real Mc2=Mc1"current distribution factor";
  parameter Real Md2=Md1"current distribution factor";
  parameter Real mod_v(unit = "pu")=1"reference bus voltage";
  parameter Complex V1=mod_v+Ia*Zb"bus1 voltage in pu";
  parameter Real V1_abs(unit = "pu") = (V1.re ^ 2 + V1.im ^ 2) ^ 0.5"absolute value of bus1 voltage";
  parameter Real V1_arg(unit = "degree") = atan(V1.im / V1.re) * R2D "angle of bus1 voltage";
  parameter Complex V2=mod_v+Ib*Za"bus2 voltage in pu";
  parameter Real V2_abs(unit = "pu") = (V2.re ^ 2 + V2.im ^ 2) ^ 0.5"absolute value of bus2 voltage";
  parameter Real V2_arg(unit = "degree") = atan(V2.im / V2.re) * R2D "angle of bus2 voltage";
  parameter Complex I_1=Ia"current from plant1";
  parameter Real I_1_arg(unit = "degree") = atan(I_1.im / I_1.re) * R2D "angle of current from plant1";
  parameter Real sigma1(unit = "degree")=I_1_arg"phase angle of current from plant1";
  parameter Complex I_2=Ib+Ic"current from plant2";
  parameter Real I_2_arg(unit = "degree") = atan(I_2.im / I_2.re) * R2D "angle of current from plant2 ";
  parameter Real sigma2(unit = "degree")=I_2_arg"phase angle of current from plant1";
  parameter Real pf1=cos((V1_arg-sigma1)*D2R)"plant1 power factor";
  parameter Real pf2=cos((V2_arg-sigma2)*D2R)"plant2 power factor";
  //calculation of loss coefficients
  parameter Real B11(unit = "pu")=((Za.re*(Ma1^2))+(Zb.re*(Mb1^2))+(Zc.re*(Mc1^2))+(Zd.re*(Md1^2)))/((V1_abs^2)*(pf1^2))"loss coefficient";
  parameter Real B22(unit = "pu")=(Za.re*(Ma2^2))+(Zb.re*(Mb2^2))+(Zc.re*(Mc2^2))+(Zd.re*(Md2^2))/((V2_abs^2)*(pf2^2))"loss coefficient";
  parameter Real B12(unit = "pu")=(Za.re*Ma1*Ma2)+(Zb.re*Mb1*Mb2)+(Zc.re*Mc1*Mc2)+(Zd.re*Md1*Md2)/(V1_abs*V2_abs*pf1*pf2)"loss coefficient";
  parameter Real Base(final quantity="Power", final unit="MVA")=100"Base voltage";
  parameter Real B11_new(final quantity="Power", final unit="(MW)^-1")=B11/Base"loss coefficient";
  parameter Real B12_new(final quantity="Power", final unit="(MW)^-1")=B12/Base"loss coefficient";
  parameter Real B22_new(final quantity="Power", final unit="(MW)^-1")=B22/Base"loss coefficient";
//The answers may slightly vary due to rounding off values.
end Ex7_7;
