model Ex7_8
parameter Modelica.SIunits.Height h0=20"basic head";
parameter Real e=0.005"correlation factor";
parameter Real p(unit = "m^3/s")=2"non-effective discharge in parameter Real ";
parameter Real P_D1(final quantity="Power", final unit="MW")=7"load in 1st step of eight hours";
parameter Real P_D2(final quantity="Power", final unit="MW")=10"load in 2nd step of eight hours";
parameter Real P_D3(final quantity="Power", final unit="MW")=5"load in 3rd step of eight hours";
parameter Real X0(unit = "m^3/s")=100"initial water storage in reservior";
parameter Real X3(unit = "m^3/s")=60"final water storage in reservior";
parameter Real j1(unit = "m^3/s")=0"water inflow rate in the 1st interval";
parameter Real j2(unit = "m^3/s")=j1"water inflow rate in the 2nd interval";
parameter Real j3(unit = "m^3/s")=j1"water inflow rate in the 3rd interval";
parameter Real storage_initial(unit = "m^3/s")=100"initial water storage in reservior";
parameter Real storage_final(unit = "m^3/s")=60"final water storage in reservior";
parameter Real Q2(unit = "m^3/s")=15"(q^2), a control variable";
parameter Real Q3(unit = "m^3/s")=15"(q^3), a control variable";
parameter Real alfa=0.5"a constant";
parameter Real Q1(unit = "m^3/s")=storage_initial-storage_final-(Q2+Q3)"water discharge in 1st subinterval";
parameter Real X1(unit = "m^3/s")=X0+j1-Q1"water storage in the 1st interval";
parameter Real X2(unit = "m^3/s")=X1+j2-Q2"water storage in the 2nd interval";
parameter Real p1_GH(final quantity="Power", final unit="MW")=9.81*1e-3*h0*(1+0.5*e*(X1+X0))*(Q1-p)"value of hydro generation in the 1st subinterval";
parameter Real p2_GH(final quantity="Power", final unit="MW")=9.81*1e-3*h0*(1+0.5*e*(X2+X1))*(Q2-p)"value of hydro generation in the 2nd subinterval";
parameter Real p3_GH(final quantity="Power", final unit="MW")=9.81*1e-3*h0*(1+0.5*e*(X3+X2))*(Q3-p)"value of hydro generation in the 3rd subinterval";
parameter Real P1_GT(final quantity="Power", final unit="MW")=P_D1-p1_GH"value of thermal generation in the 1st subinterval";
parameter Real P2_GT(final quantity="Power", final unit="MW")=P_D2-p2_GH"value of thermal generation in the 2nd subinterval";
parameter Real P3_GT(final quantity="Power", final unit="MW")=P_D3-p3_GH"value of thermal generation in the 3rd subinterval";
parameter Real lambda1_1=P1_GT+25"dual variable for 1st interval";
parameter Real lambda1_2=P2_GT+25"dual variable for 2nd interval";
parameter Real lambda1_3=P3_GT+25"dual variable for 3rd interval";
parameter Real lambda3_1=lambda1_1"dual variable for 1st interval for lossless case";
parameter Real lambda3_2=lambda1_2"dual variable for 2nd interval for lossless case";
parameter Real lambda3_3=lambda1_3"dual variable for 3rd interval for lossless case";
parameter Real lambda2_1=lambda3_1*9.81*1e-3*h0*(1+0.5*e*((2*X0)+j1-(2*Q1)+p))"dual variable";
parameter Real lambda2_2=lambda2_1-(lambda3_1*(0.5*9.81*1e-3*h0*e*(Q1-p)))-(lambda3_1*(0.5*9.81*1e-3*h0*e*(Q2-p)))"dual variable";
parameter Real lambda2_3=lambda2_2-(lambda3_2*(0.5*9.81*1e-3*h0*e*(Q2-p)))-(lambda3_2*(0.5*9.81*1e-3*h0*e*(Q3-p)))"dual variable";
parameter Real G_v_1=lambda2_2-(lambda3_2*9.81*1e-3*h0*(1+0.5*e*((2*X1)-(2*Q2)+p)))"gradient vector";
parameter Real G_v_2=lambda2_3-(lambda3_3*9.81*1e-3*h0*(1+0.5*e*((2*X2)+j3-(2*Q3)+p)))"gradient vector";
parameter Real Q2_new(unit = "m^3/s")=Q2-alfa*G_v_1"new value of control variable";
parameter Real Q3_new(unit = "m^3/s")=Q3-alfa*G_v_2"new value of control variable";
parameter Real Q1_new(unit = "m^3/s")=storage_initial-storage_final-(Q2_new+Q3_new)"new value of control variable";
//The answers may slightly vary due to rounding off values.
end Ex7_8;
