model Ex9_1
OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = G1, V_b = V_bG, Vn = 11, ra = 0, x1d = X1) annotation(
    Placement(visible = true, transformation(origin = {-136, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 8, Sn = G2, V_b = V_bG, Vn = 11, ra = 0, x1d = X2) annotation(
    Placement(visible = true, transformation(origin = {-136, -26}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_b = 11, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-96, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = T1, r = 0, x = X3) annotation(
    Placement(visible = true, transformation(origin = {-68, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_b = V_bl, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {42, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(Sn = T2, r = 0, x = X4) annotation(
    Placement(visible = true, transformation(origin = {76, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(R = R1, X = X5) annotation(
    Placement(visible = true, transformation(origin = {0, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_b = V_bc, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {118, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = R2, X = X6, t1 = 35, t2 = 55) annotation(
    Placement(visible = true, transformation(origin = {150, -34}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = S_n, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {163, 72}, extent = {{-23, -20}, {23, 20}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_b = 11, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-36, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));

  constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi "Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Real l(final quantity="Length", final unit="km") = 30 "length of overhead line";
  parameter Real G1(final quantity="Power", final unit="MVA") = 10 "rating of generator1";
  parameter Real G2(final quantity="Power", final unit="MVA") = 10 "rating of generator2";
  parameter Real T1(final quantity="Power", final unit="MVA") = 10 "rating of transformer 1 ";
  parameter Real T2(final quantity="Power", final unit="MVA") = 5 "rating of transformer 2";
  parameter Real V_bG(final quantity="ElectricPotential", final unit="kV") = 11 "voltage bases of generators";
  parameter Real V_bl(final quantity="ElectricPotential", final unit="kV") = 33 "voltage bases of overhead line";
  parameter Real V_bc(final quantity="ElectricPotential", final unit="kV") = 6.6 "voltage bases of cable";
  parameter Real X1(unit = "pu") = 1.5"reactance of generator1";
  parameter Real X2(unit = "pu") = 1.25"reactance of generator2";
  parameter Real X3(unit = "pu") = 1"reactance of transformer1";
  parameter Real X4(unit = "pu") = 1.6"reactance of transformer2";
  parameter Real R1(unit = "pu") = 0.744"resistance of overhead line";
  parameter Real X5(unit = "pu") = 0.99"reactance of over head line";
  parameter Real R2(unit = "pu") = 0.93"resistance of cable and fault";
  parameter Real X6(unit = "pu") = 0.55"reactance of cable and fault";
  parameter Real S_n(final quantity="Power", final unit="MVA") = 100 "system base";
  parameter Complex XG1 = Complex(0, X1) "reactance of generator1 in complex form in pu";
  parameter Complex XG2 = Complex(0, X2) "reactance of generator2 in complex form in pu";
  parameter Complex XT1 = Complex(0, X3) "reactance of transformer1 in complex form in pu";
  parameter Complex XT2 = Complex(0, X4) "reactance of transformer2 in complex form in pu";
  parameter Complex Xl = Complex(R1, X5) "impedance of over head line in complex form in pu";
  parameter Complex Xc = Complex(R2, X6) "impedance of cable and fault in complex form in pu";
  parameter Complex Z_total = XG1 * XG2 / (XG1 + XG2) + XT1 + Xl + XT2 + Xc "total impedance in pu";
  parameter Real Z_total_abs(unit = "pu") = (Z_total.re ^ 2 + Z_total.im ^ 2) ^ 0.5"absolute value of total impedance";
  parameter Real Z_total_arg(unit = "degree") = atan(Z_total.im / Z_total.re) * R2D "angle of total impedance";
  parameter Complex Vg = Complex(1 * cos(0), 1 * sin(0))"total voltage in  pu";
  parameter Real Vg_abs(unit = "pu") = (Vg.re ^ 2 + Vg.im ^ 2) ^ 0.5"absolute value of total voltage";
  parameter Real Vg_arg(unit = "degree") = atan(Vg.im / Vg.re) * R2D "angle of total voltage";
  parameter Complex I_sc = Vg / Z_total"current through the circuit";
  parameter Real I_sc_abs(unit = "pu") = (I_sc.re ^ 2 + I_sc.im ^ 2) ^ 0.5"absolute value of current through the circuit";
  parameter Real I_sc_arg(unit = "degree") = atan(I_sc.im / I_sc.re) * R2D "angle of current through the circuit";
  parameter Modelica.SIunits.Current I_base = S_n * 1e3 / (3 ^ 0.5 * V_bc)"base current";
  parameter Modelica.SIunits.Current I_sc1 = I_sc_abs * I_base"fault current";
  parameter Complex Z_total_ftob = Xc + XT2 + Xl + XT1 "total impedance between fault and 11kv bus in pu";
  parameter Real Z_total_ftob_abs(unit = "pu") = (Z_total_ftob.re ^ 2 + Z_total_ftob.im ^ 2) ^ 0.5"a bsolute value of total impedance between fault and 11kv bus";
  parameter Real Z_total_ftob_arg(unit = "degree") = atan(Z_total_ftob.im / Z_total_ftob.re) * R2D "angle of total impedance between fault and 11kv bus";
  parameter Complex V_b = I_sc * Z_total_ftob"voltage at 11kv bus in complex form in pu";
  parameter Real V_b_abs(unit = "pu") = (V_b.re ^ 2 + V_b.im ^ 2) ^ 0.5"absolute value of voltage at 11 kv bus";
  parameter Real V_b_arg(unit = "degree") = atan(V_b.im / V_b.re) * R2D "angle of voltage at 11 kv bus";
  parameter Real V_bus(final quantity="ElectricPotential", final unit="kV") = V_b_abs * V_bG "voltage at 11 kv bus under fault condition ";
 equation
  connect(bus3.p, pwFault1.p) annotation(
    Line(points = {{118, 0}, {140, 0}, {140, 0}, {150, 0}, {150, -26}, {150, -26}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus4.p) annotation(
    Line(points = {{-9, 0}, {-36, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, bus4.p) annotation(
    Line(points = {{-56, 0}, {-36, 0}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus2.p) annotation(
    Line(points = {{9, 0}, {42, 0}}, color = {0, 0, 255}));
  connect(bus2.p, twoWindingTransformer2.n) annotation(
    Line(points = {{42, 0}, {65, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.p, bus3.p) annotation(
    Line(points = {{87, 0}, {118, 0}}, color = {0, 0, 255}));
  connect(generator2.pm0, generator2.pm) annotation(
    Line(points = {{-144, -36}, {-144, -36}, {-144, -46}, {-156, -46}, {-156, -32}, {-148, -32}, {-148, -30}}, color = {0, 0, 127}));
  connect(generator2.vf0, generator2.vf) annotation(
    Line(points = {{-144, -14}, {-144, -14}, {-144, -6}, {-156, -6}, {-156, -20}, {-148, -20}, {-148, -20}}, color = {0, 0, 127}));
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-144, 20}, {-144, 20}, {-144, 12}, {-156, 12}, {-156, 26}, {-148, 26}, {-148, 26}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-144, 42}, {-144, 42}, {-144, 50}, {-156, 50}, {-156, 36}, {-148, 36}, {-148, 36}}, color = {0, 0, 127}));
  connect(bus1.p, twoWindingTransformer1.n) annotation(
    Line(points = {{-96, 0}, {-80, 0}, {-80, 0}, {-78, 0}}, color = {0, 0, 255}));
  connect(bus1.p, generator2.p) annotation(
    Line(points = {{-96, 0}, {-96, 0}, {-96, -6}, {-114, -6}, {-114, -26}, {-126, -26}, {-126, -26}}, color = {0, 0, 255}));
  connect(bus1.p, generator1.p) annotation(
    Line(points = {{-96, 0}, {-96, 0}, {-96, 6}, {-114, 6}, {-114, 30}, {-126, 30}, {-126, 30}}, color = {0, 0, 255}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");


end Ex9_1;
