model Ex9_4
inner OpenIPSL.Electrical.SystemBase SysData(S_b = S_n) annotation(
    Placement(visible = true, transformation(origin = {-153, 67}, extent = {{-19, -19}, {19, 19}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, S_b = 40, Sn = 40, V_b = 6.6, Vn = 6.6, ra = 0, x1d = X2)  annotation(
    Placement(visible = true, transformation(origin = {-60, 50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 8, S_b = 50, Sn = 50, V_b = 6.6, Vn = 6.6, ra = 0, x1d = X3)  annotation(
    Placement(visible = true, transformation(origin = {0, 50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator3(D = 0, M = 8, S_b = 25, Sn = 25, V_b = 6.6, Vn = 6.6, ra = 0, x1d = X4)  annotation(
    Placement(visible = true, transformation(origin = {60, 50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-60, 14}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {0, 14}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker3 annotation(
    Placement(visible = true, transformation(origin = {60, 14}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-60, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {0, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {60, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = R1, X = X1)  annotation(
    Placement(visible = true, transformation(origin = {-52, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = X5)  annotation(
    Placement(visible = true, transformation(origin = {-76, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = X6)  annotation(
    Placement(visible = true, transformation(origin = {0, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = X7)  annotation(
    Placement(visible = true, transformation(origin = {60, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Events.Breaker breaker4 annotation(
    Placement(visible = true, transformation(origin = {-52,-54}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4 annotation(
    Placement(visible = true, transformation(origin = {0, -74}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.12, t1 = 15, t2 = 40)  annotation(
    Placement(visible = true, transformation(origin = {0, -90}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));

constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real R1(unit = "pu")=0.069"feeder resistance";
parameter Real X1(unit = "pu")=0.138"feeder reactance";
parameter Real X2(unit = "pu")=0.125"reactance of generator1";
parameter Real X3(unit = "pu")=0.1"reactance of generator2";
parameter Real X4(unit = "pu")=0.2"reactance of generator3";
parameter Real X5(unit = "pu")=0.15"reactance of reactor1";
parameter Real X6(unit = "pu")=0.12"reactance of reactor2";
parameter Real X7(unit = "pu")=0.24"reactance of reactor3";
parameter Real S_n(final quantity="Power", final unit="MVA")=50"system base";
parameter Complex Xf=Complex(R1,X1)"impedance of feeder in complex form in pu";
parameter Complex XG1=Complex(0,X2)"reactance of generator1 in complex form in pu";
parameter Complex XG2=Complex(0,X3)"reactance of generator2 in complex form in pu";
parameter Complex XG3=Complex(0,X4)"reactance of generator3 in complex form in pu";
parameter Complex Xr1=Complex(0,X5)"reactance of reactor1 in complex form in pu";
parameter Complex Xr2=Complex(0,X6)"reactance of reactor2 in complex form in pu";
parameter Complex Xr3=Complex(0,X7)"reactance of reactor3 in complex form in pu";
parameter Complex Z=Xf+(XG1*(Xr1+(((XG2+Xr2)*(XG3+Xr3))/(XG2+Xr2+XG3+Xr3)))/(XG1+(Xr1+(((XG2+Xr2)*(XG3+Xr3))/(XG2+Xr2+XG3+Xr3)))))"total impedance of the circuit";
parameter Real Z_abs(unit = "pu") = (Z.re ^ 2 + Z.im ^ 2) ^ 0.5"absolute value of total impedance of the circuit";
parameter Real Z_arg(unit = "degree") = atan(Z.im / Z.re) * R2D "angle of total impedance of the circuit";
parameter Real SC_MVA(final quantity="Power", final unit="MVA")=S_n/Z_abs"the maximum MVA that can be fed into a symmetrical short circuit at the far end of the feeder";
equation
  connect(generator3.vf, generator3.vf0) annotation(
    Line(points = {{66, 62}, {66, 62}, {66, 70}, {78, 70}, {78, 58}, {72, 58}, {72, 58}}, color = {0, 0, 127}));
  connect(generator3.pm, generator3.pm0) annotation(
    Line(points = {{56, 62}, {54, 62}, {54, 70}, {44, 70}, {44, 58}, {50, 58}, {50, 58}}, color = {0, 0, 127}));
  connect(generator2.vf, generator2.vf0) annotation(
    Line(points = {{6, 62}, {6, 62}, {6, 70}, {16, 70}, {16, 58}, {12, 58}, {12, 58}}, color = {0, 0, 127}));
  connect(generator2.pm, generator2.pm0) annotation(
    Line(points = {{-4, 62}, {-6, 62}, {-6, 70}, {-16, 70}, {-16, 58}, {-10, 58}, {-10, 58}}, color = {0, 0, 127}));
  connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-54, 62}, {-54, 62}, {-54, 70}, {-42, 70}, {-42, 58}, {-48, 58}, {-48, 58}}, color = {0, 0, 127}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-64, 62}, {-66, 62}, {-66, 70}, {-78, 70}, {-78, 58}, {-70, 58}, {-70, 58}}, color = {0, 0, 127}));
  connect(bus4.p, pwLine4.n) annotation(
    Line(points = {{0, -74}, {4, -74}, {4, -66}, {60, -66}, {60, -39}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine4.p) annotation(
    Line(points = {{60, -10}, {60, -21}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus4.p) annotation(
    Line(points = {{0, -39}, {0, -74}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.p) annotation(
    Line(points = {{0, -10}, {0, -21}}, color = {0, 0, 255}));
  connect(pwLine2.p, bus1.p) annotation(
    Line(points = {{-76, -21}, {-76, -16}, {-60, -16}, {-60, -10}}, color = {0, 0, 255}));
  connect(bus4.p, pwLine2.n) annotation(
    Line(points = {{0, -74}, {-6, -74}, {-6, -68}, {-76, -68}, {-76, -39}}, color = {0, 0, 255}));
  connect(pwFault1.p, bus4.p) annotation(
    Line(points = {{0, -82}, {0, -82}, {0, -74}, {0, -74}}, color = {0, 0, 255}));
  connect(bus4.p, breaker4.r) annotation(
    Line(points = {{0, -74}, {-2, -74}, {-2, -66}, {-52, -66}, {-52, -58}, {-52, -58}}, color = {0, 0, 255}));
  connect(pwLine1.n, breaker4.s) annotation(
    Line(points = {{-52, -38}, {-52, -38}, {-52, -48}, {-52, -48}}, color = {0, 0, 255}));
  connect(breaker3.r, bus3.p) annotation(
    Line(points = {{60, 10}, {60, 10}, {60, -10}, {60, -10}}, color = {0, 0, 255}));
  connect(breaker2.r, bus2.p) annotation(
    Line(points = {{0, 10}, {0, 10}, {0, -10}, {0, -10}}, color = {0, 0, 255}));
  connect(generator3.p, breaker3.s) annotation(
    Line(points = {{60, 40}, {60, 20}}, color = {0, 0, 255}));
  connect(generator2.p, breaker2.s) annotation(
    Line(points = {{0, 40}, {0, 20}}, color = {0, 0, 255}));
  connect(generator1.p, breaker1.s) annotation(
    Line(points = {{-60, 40}, {-60, 20}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-60, -10}, {-52, -10}, {-52, -20}, {-52, -20}, {-52, -20}}, color = {0, 0, 255}));
  connect(breaker1.r, bus1.p) annotation(
    Line(points = {{-60, 8}, {-60, 8}, {-60, -10}, {-60, -10}}, color = {0, 0, 255}));
annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex9_4;
