model Ex9_6
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-153, 63}, extent = {{-25, -19}, {25, 19}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, S_b = 100, Sn = 100, V_b = 11, Vn = 11, ra = 0, x1d = XG) annotation(
    Placement(visible = true, transformation(origin = {-71, 75}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 100, Vn = 110, r = 0, x = XT) annotation(
    Placement(visible = true, transformation(origin = {-72, 42}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-72, 20}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {58, 18}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {-72, -32}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {62, -34}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = X1) annotation(
    Placement(visible = true, transformation(origin = {-4, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = X3) annotation(
    Placement(visible = true, transformation(origin = {-4, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = X4) annotation(
    Placement(visible = true, transformation(origin = {-72, -2}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = X5) annotation(
    Placement(visible = true, transformation(origin = {62, -2}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0, G = 0, R = 0, X = X2) annotation(
    Placement(visible = true, transformation(origin = {-2, -4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(Sn = 100, V_b = 110, r = 0, x = XT) annotation(
    Placement(visible = true, transformation(origin = {66, -54}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22(D = 0, M = 8, S_b = S_n, Sn = 100, V_b = 11, Vn = 11, ra = 0, x1d = XG) annotation(
    Placement(visible = true, transformation(origin = {67, -81}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 5, t2 = 50) annotation(
    Placement(visible = true, transformation(origin = {-72, -80}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {58, 68}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-72, -54}, extent = {{-4, -4}, {4, 4}}, rotation = -90)));
  
parameter Real XG(unit = "pu")=0.1"reactance of generator";
parameter Real XT(unit = "pu")=0.05"reactance of transformer";
parameter Real X1(unit = "pu")=0.15"reactance of power line1";
parameter Real X2(unit = "pu")=0.2"reactance of power line5";
parameter Real X3(unit = "pu")=0.15"reactance of power line2";
parameter Real X4(unit = "pu")=0.1"reactance of power line3";
parameter Real X5(unit = "pu")=0.1"reactance of power line4";
parameter Real S_n(final quantity="Power", final unit="MVA")=100"system base";
parameter Real V1_0(unit = "pu")=1"bus1 prefault voltage";
parameter Real V2_0(unit = "pu")=1"bus2 prefault voltage";
parameter Real V3_0(unit = "pu")=1"bus3 prefault voltage";
parameter Real V4_0(unit = "pu")=1"bus4 prefault voltage";
parameter Complex Z1=Complex(0,X1)"impedance,obtained after simplying the circuit in pu";
parameter Complex Z2=Complex(0,X2)"impedance,obtained after simplying the circuit in pu";
parameter Complex Z3=Complex(0,X3)"impedance,obtained after simplying the circuit in pu";
parameter Complex Z4=Complex(0,X4)"impedance,obtained after simplying the circuit in pu";
parameter Complex Y11=(1/Z1)+(1/Z2)+(1/Z3)+(1/Z4)"admittance in pu";
parameter Complex Y12=-(1/Z2)"admittance in pu";
parameter Complex Y21=Y12"admittance in pu";
parameter Complex Y13=-(1/Z3)"admittance in pu";
parameter Complex Y31=Y13"admittance in pu";
parameter Complex Y14=-(1/Z4)"admittance in pu";
parameter Complex Y41=Y14"admittance in pu";
parameter Complex Y22=Y11"admittance in pu";
parameter Complex Y23=Y14"admittance in pu";
parameter Complex Y32=Y14"admittance in pu";
parameter Complex Y24=Y13"admittance in pu";
parameter Complex Y42=Y13"admittance in pu";
parameter Complex Y33=(1/Z1)+(1/Z4)"admittance in pu";
parameter Complex Y44=Y33"admittance in pu";
parameter Complex Y34=Complex(0,0)"admittance in pu";
parameter Complex Y43=Y34"admittance in pu";
parameter Complex [4,4]Y_bus={{Y11,Y12,Y13,Y14},{Y21,Y22,Y23,Y24},{Y31,Y32,Y33,Y34},{Y41,Y42,Y43,Y44}}"bus admittance matrix for the system";
  // By inversion we get Zbus,here inverse of a complex matrix can't be done due to limitation of this open source software
  parameter Complex Z11=Complex(0,0.0903)"impedance in pu";
parameter Complex Z12=Complex(0,0.0597)"impedance in pu";
parameter Complex Z21=Z12"impedance in pu";
parameter Complex Z13=Complex(0,0.0719)"impedance in pu";
parameter Complex Z31=Z13"impedance in pu";
parameter Complex Z14=Complex(0,0.0780)"impedance in pu";
parameter Complex Z41=Z14"impedance in pu";
parameter Complex Z22=Z11"impedance in pu";
parameter Complex Z23=Z14"impedance in pu";
parameter Complex Z32=Z14"impedance in pu";
parameter Complex Z24=Z13"impedance in pu";
parameter Complex Z42=Z13"impedance in pu";
parameter Complex Z33=Complex(0,0.1356)"impedance in pu";
parameter Complex Z44=Z33"impedance in pu";
parameter Complex Z34=Complex(0,0.0743)"impedance in pu";
parameter Complex Z43=Z34"impedance in pu";
parameter Complex [4,4]Z_bus={{Z11,Z12,Z13,Z14},{Z21,Z22,Z23,Z24},{Z31,Z32,Z33,Z34},{Z41,Z42,Z43,Z44}}"bus impedance matrix for the system";
parameter Real Vf1(unit = "pu")=V1_0-((Z14.im/Z44.im)*V4_0)"post fault bus1 voltage";
parameter Real Vf2(unit = "pu")=V2_0-((Z24.im/Z44.im)*V4_0)"post fault bus2 voltage";
parameter Real Vf3(unit = "pu")=V3_0-((Z34.im/Z44.im)*V4_0)"post fault bus3 voltage";
parameter Real Vf4(unit = "pu")=V4_0-((Z44.im/Z44.im)*V4_0)"post fault bus4 voltage";
parameter Complex If=V1_0/Z44"fault current in pu";
parameter Complex If_13=(Vf1-Vf3)/Z3"short circuit current in lines 1-3";
parameter Complex If_12=(Vf1-Vf2)/Z2"short circuit current in lines 1-2";
parameter Complex If_14=(Vf1-Vf4)/Z4"short circuit current in lines 1-4";
parameter Complex If_24=(Vf2-Vf4)/Z1"short circuit current in lines 2-4";
parameter Complex If_23=(Vf2-Vf3)/Z4"short circuit current in lines 2-3";
parameter Complex If_new=V1_0/Z11"fault current for a fault on bus 1 in pu";
equation
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{70, -90}, {70, -90}, {70, -94}, {80, -94}, {80, -86}, {74, -86}, {74, -86}}, color = {0, 0, 127}));
  connect(order22.vf0, order22.vf) annotation(
    Line(points = {{60, -86}, {54, -86}, {54, -94}, {64, -94}, {64, -90}, {64, -90}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-68, 84}, {-68, 84}, {-68, 88}, {-58, 88}, {-58, 80}, {-64, 80}, {-64, 80}}, color = {0, 0, 127}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-78, 80}, {-84, 80}, {-84, 88}, {-74, 88}, {-74, 84}, {-74, 84}}, color = {0, 0, 127}));
  connect(bus1.p, pwLine5.p) annotation(
    Line(points = {{-72, 20}, {-64, 20}, {-64, -4}, {-10, -4}, {-10, -4}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.p) annotation(
    Line(points = {{-72, -32}, {-68, -32}, {-68, -40}, {-12, -40}, {-12, -40}}, color = {0, 0, 255}));
  connect(breaker1.r, pwFault1.p) annotation(
    Line(points = {{-72, -59}, {-72, -73}}, color = {0, 0, 255}));
  connect(breaker1.s, bus3.p) annotation(
    Line(points = {{-72, -49}, {-72, -32}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus3.p) annotation(
    Line(points = {{-72, -11}, {-72, -32}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine3.p) annotation(
    Line(points = {{-72, 20}, {-72, 7}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-72, 20}, {-66, 20}, {-66, 30}, {-13, 30}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-72, 31}, {-72, 20}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, order21.p) annotation(
    Line(points = {{-72, 53}, {-72, 68}, {-71, 68}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus4.p) annotation(
    Line(points = {{6, -40}, {62, -40}, {62, -34}, {62, -34}}, color = {0, 0, 255}));
  connect(pwLine5.n, bus4.p) annotation(
    Line(points = {{7, -4}, {54, -4}, {54, -34}, {62, -34}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{6, 30}, {50, 30}, {50, 18}, {58, 18}, {58, 18}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, order22.p) annotation(
    Line(points = {{66, -64}, {66, -64}, {66, -74}, {68, -74}}, color = {0, 0, 255}));
  connect(bus4.p, twoWindingTransformer2.p) annotation(
    Line(points = {{62, -34}, {66, -34}, {66, -43}}, color = {0, 0, 255}));
  connect(pwLine4.n, bus4.p) annotation(
    Line(points = {{62, -11}, {62, -34}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine4.p) annotation(
    Line(points = {{58, 18}, {62, 18}, {62, 7}}, color = {0, 0, 255}));
  connect(voltDependant1.p, bus2.p) annotation(
    Line(points = {{58, 58}, {58, 18}}, color = {0, 0, 255}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");


end Ex9_6;
