model Ex1_9
  parameter Modelica.SIunits.Voltage Voc = 0.24 "open circuit voltage";
  parameter Real Isc(final quantity = "ElectricCurrent", final unit = "mA") = -9 "short circuit current";
  parameter Modelica.SIunits.Voltage Vmax = 0.14 "maximum voltage";
  parameter Real Imax(final quantity = "ElectricCurrent", final unit = "mA") = -6 "maximum current";
  parameter Modelica.SIunits.SoundIntensity I = 200 "Intensity of solar cell";
  parameter Real A(final quantity = "Area", final unit = "cm2") = 4 "area of solar cell";
  parameter Modelica.SIunits.Power Pmax = Imax * 1e-3 * Vmax "maximum power of solar cell";
  parameter Modelica.SIunits.Power Pmax_output = -1 * Pmax "taking mod value of maximum power";
  parameter Modelica.SIunits.Power Pinput = I * A * 1e-4 "input power";
  parameter Real efficiency(unit = "%") = Pmax_output / Pinput * 100 "efficiency of solar cell";
end Ex1_9;
