model Ex10_1
  constant Real pi = 2 * Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Modelica.SIunits.ComplexCurrent Ia = Complex(10 * cos(pi / 6), 10 * sin(pi / 6))"current in line A";
  parameter Modelica.SIunits.ComplexCurrent Ib = Complex(15 * cos(-pi / 3), 15 * sin(-pi / 3))"current in line B";
  parameter Modelica.SIunits.Current Ib_abs = (Ib.re ^ 2 + Ib.im ^ 2) ^ 0.5"absolute value of current in line B";
  parameter Real Ib_arg(unit = "degree") = atan(Ib.im / Ib.re) * R2D "angle of current in line B";
  parameter Modelica.SIunits.ComplexCurrent Ic = -(Ia + Ib) "current in line C as (Ia+Ib+Ic)=0";
  parameter Modelica.SIunits.Current Ic_abs = (Ic.re ^ 2 + Ic.im ^ 2) ^ 0.5"absolute value of current in line C";
  parameter Real Ic_arg(unit = "degree") = atan(Ic.im / Ic.re) * R2D "angle of current in line C";
  parameter Real Ic_arg1(unit = "degree") = Ic_arg + 180"modified angle of current in line C";
  parameter Modelica.SIunits.ComplexCurrent Ib_1 = Complex(Ib_abs * cos((Ib_arg + 120) * D2R), Ib_abs * sin((Ib_arg + 120) * D2R))"current phasor in line B";
  parameter Modelica.SIunits.Current Ib_1_abs = (Ib_1.re ^ 2 + Ib_1.im ^ 2) ^ 0.5"absolute value of current phasor in line B ";
  parameter Real Ib_1_arg(unit = "degree") = atan(Ib_1.im / Ib_1.re) * R2D "angle of current phasor in line B ";
  parameter Modelica.SIunits.ComplexCurrent Ic_1 = Complex(Ic_abs * cos((Ic_arg1 + 240) * D2R), Ic_abs * sin((Ic_arg1 + 240) * D2R))"current phasor in line C";
  parameter Modelica.SIunits.Current Ic_1_abs = (Ic_1.re ^ 2 + Ic_1.im ^ 2) ^ 0.5"absolute value of current phasor in line C ";
  parameter Real Ic_1_arg(unit = "degree") = atan(Ic_1.im / Ic_1.re) * R2D "angle of current phasor in line C ";
  parameter Real Ic_1_arg1(unit = "degree") = Ic_1_arg + 360"modified angle of current phasor in line C ";
  parameter Modelica.SIunits.ComplexCurrent IA1 = 1 / 3 * (Ia + Ib_1 + Ic_1)"symmetrical component of line current";
  parameter Modelica.SIunits.Current IA1_abs = (IA1.re ^ 2 + IA1.im ^ 2) ^ 0.5"absolute value of symmetrical component of line current";
  parameter Real IA1_arg(unit = "degree") = atan(IA1.im / IA1.re) * R2D "angle of symmetrical component of line current";
  parameter Modelica.SIunits.ComplexCurrent Ib_2 = Complex(Ib_abs * cos((Ib_arg + 240) * D2R), Ib_abs * sin((Ib_arg + 240) * D2R))"current phasor in line B";
  parameter Modelica.SIunits.Current Ib_2_abs = (Ib_2.re ^ 2 + Ib_2.im ^ 2) ^ 0.5"absolute value of current phasor in line B ";
  parameter Real Ib_2_arg(unit = "degree") = atan(Ib_2.im / Ib_2.re) * R2D "angle of current phasor in line B ";
  parameter Modelica.SIunits.ComplexCurrent Ic_2 = Complex(Ic_abs * cos((Ic_arg1 + 120) * D2R), Ic_abs * sin((Ic_arg1 + 120) * D2R))"current phasor in line C";
  parameter Modelica.SIunits.Current Ic_2_abs = (Ic_2.re ^ 2 + Ic_2.im ^ 2) ^ 0.5"absolute value of current phasor in line C ";
  parameter Real Ic_2_arg(unit = "degree") = atan(Ic_2.im / Ic_2.re) * R2D "angle of current phasor in line C";
  parameter Real Ic_2_arg1(unit = "degree") = Ic_2_arg + 360"modified angle of current phasor in line C";
  parameter Modelica.SIunits.ComplexCurrent IA2 = 1 / 3 * (Ia + Ib_2 + Ic_2)"symmetrical component of line current";
  parameter Modelica.SIunits.Current IA2_abs = (IA2.re ^ 2 + IA2.im ^ 2) ^ 0.5"absolute value of symmetrical component of line current";
  parameter Real IA2_arg(unit = "degree") = atan(IA2.im / IA2.re) * R2D "angle of symmetrical component of line current";
  parameter Real IA2_arg1(unit = "degree") = IA2_arg + 180"modified angle of symmetrical component of line current";
  parameter Modelica.SIunits.ComplexCurrent IA0 = 1 / 3 * (Ia + Ib + Ic)"zero sequence line current";
  parameter Modelica.SIunits.ComplexCurrent IB1 = Complex(IA1_abs * cos((IA1_arg + 240) * D2R), IA1_abs * sin((IA1_arg + 240) * D2R))"symmetrical component of line current";
  parameter Modelica.SIunits.Current IB1_abs = (IB1.re ^ 2 + IB1.im ^ 2) ^ 0.5"absolute value of symmetrical component of line current";
  parameter Real IB1_arg(unit = "degree") = atan(IB1.im / IB1.re) * R2D "angle of symmetrical component of line current";
  parameter Real IB1_arg1(unit = "degree") = IB1_arg + 360"modified angle of symmetrical component of line current";
  parameter Modelica.SIunits.ComplexCurrent IB2 = Complex(IA2_abs * cos((IA2_arg - 240) * D2R), IA2_abs * sin((IA2_arg - 240) * D2R))"symmetrical component of line current";
  parameter Modelica.SIunits.Current IB2_abs = (IB2.re ^ 2 + IB2.im ^ 2) ^ 0.5"absolute value of symmetrical component of line current";
  parameter Real IB2_arg(unit = "degree") = atan(IB2.im / IB2.re) * R2D "angle of symmetrical component of line current";
  parameter Modelica.SIunits.ComplexCurrent IB0 = 1 / 3 * (Ia + Ib + Ic)"zero sequence line current";
  parameter Modelica.SIunits.ComplexCurrent IC1 = Complex(IA1_abs * cos((IA1_arg + 120) * D2R), IA1_abs * sin((IA1_arg + 120) * D2R))"symmetrical component of line current";
  parameter Modelica.SIunits.Current IC1_abs = (IC1.re ^ 2 + IC1.im ^ 2) ^ 0.5"absolute value of symmetrical component of line current";
  parameter Real IC1_arg(unit = "degree") = atan(IC1.im / IC1.re) * R2D "angle of symmetrical component of line current";
  parameter Real IC1_arg1(unit = "degree") = IC1_arg + 180"modified angle of symmetrical component of line current";
  parameter Modelica.SIunits.ComplexCurrent IC2 = Complex(IA2_abs * cos((IA2_arg - 120) * D2R), IA2_abs * sin((IA2_arg - 120) * D2R))"symmetrical component of line current";
  parameter Modelica.SIunits.Current IC2_abs = (IC2.re ^ 2 + IC2.im ^ 2) ^ 0.5"absolute value of symmetrical component of line current";
  parameter Real IC2_arg(unit = "degree") = atan(IC2.im / IC2.re) * R2D "angle of symmetrical component of line current";
  parameter Real IC2_arg1(unit = "degree") = IC2_arg + 180"modified angle of symmetrical component of line current";
  parameter Modelica.SIunits.ComplexCurrent IC0 = 1 / 3 * (Ia + Ib + Ic)"zero sequence line current";
  parameter Modelica.SIunits.ComplexCurrent IAB = 1 / 3 * (Ia - Ib) "delta current";
  parameter Modelica.SIunits.Current IAB_abs = (IAB.re ^ 2 + IAB.im ^ 2) ^ 0.5"absolute value of delta currents";
  parameter Real IAB_arg(unit = "degree") = atan(IAB.im / IAB.re) * R2D "angle of delta currents";
  parameter Modelica.SIunits.ComplexCurrent IBC = 1 / 3 * (Ib - Ic) "delta current";
  parameter Modelica.SIunits.Current IBC_abs = (IBC.re ^ 2 + IBC.im ^ 2) ^ 0.5"absolute value of delta currents";
  parameter Real IBC_arg(unit = "degree") = atan(IBC.im / IBC.re) * R2D "angle of delta currents";
  parameter Modelica.SIunits.ComplexCurrent ICA = 1 / 3 * (Ic - Ia) "delta current";
  parameter Modelica.SIunits.Current ICA_abs = (ICA.re ^ 2 + ICA.im ^ 2) ^ 0.5"absolute value of delta currents";
  parameter Real ICA_arg(unit = "degree") = atan(ICA.im / ICA.re) * R2D "angle of delta currents";
  parameter Real ICA_arg1(unit = "degree") = ICA_arg + 180"modified angle of delta currents";
  parameter Modelica.SIunits.ComplexCurrent IBC_1 = Complex(IBC_abs * cos((IBC_arg + 120) * D2R), IBC_abs * sin((IBC_arg + 120) * D2R))"current phasor of delta current";
  parameter Modelica.SIunits.Current IBC_1_abs = (IBC_1.re ^ 2 + IBC_1.im ^ 2) ^ 0.5"absolute value of current phasor of delta current";
  parameter Real IBC_1_arg(unit = "degree") = atan(IBC_1.im / IBC_1.re) * R2D "angle of current phasor of delta current";
  parameter Modelica.SIunits.ComplexCurrent ICA_1 = Complex(ICA_abs * cos((ICA_arg1 + 240) * D2R), ICA_abs * sin((ICA_arg1 + 240) * D2R))"current phasor of delta current";
  parameter Modelica.SIunits.Current ICA_1_abs = (ICA_1.re ^ 2 + ICA_1.im ^ 2) ^ 0.5"absolute value of current phasor of delta current";
  parameter Real ICA_1_arg(unit = "degree") = atan(ICA_1.im / ICA_1.re) * R2D "angle of current phasor of delta current";
  parameter Modelica.SIunits.ComplexCurrent IAB1 = 1 / 3 * (IAB + IBC_1 + ICA_1)"symmetrical component of delta current";
  parameter Modelica.SIunits.Current IAB1_abs = (IAB1.re ^ 2 + IAB1.im ^ 2) ^ 0.5"absolute value of symmetrical component of delta current";
  parameter Real IAB1_arg(unit = "degree") = atan(IAB1.im / IAB1.re) * R2D "angle of symmetrical component of delta current";
  parameter Modelica.SIunits.ComplexCurrent IBC_2 = Complex(IBC_abs * cos((IBC_arg + 240) * D2R), IBC_abs * sin((IBC_arg + 240) * D2R))"current phasor of delta current";
  parameter Modelica.SIunits.Current IBC_2_abs = (IBC_2.re ^ 2 + IBC_2.im ^ 2) ^ 0.5"absolute value of current phasor of delta current";
  parameter Real IBC_2_arg(unit = "degree") = atan(IBC_2.im / IBC_2.re) * R2D "angle of current phasor of delta current";
  parameter Modelica.SIunits.ComplexCurrent ICA_2 = Complex(ICA_abs * cos((ICA_arg1 + 120) * D2R), ICA_abs * sin((ICA_arg1 + 120) * D2R))"current phasor of delta current";
  parameter Modelica.SIunits.Current ICA_2_abs = (ICA_2.re ^ 2 + ICA_2.im ^ 2) ^ 0.5"absolute value of current phasor of delta current";
  parameter Real ICA_2_arg(unit = "degree") = atan(ICA_2.im / ICA_2.re) * R2D "angle of current phasor of delta current";
  parameter Modelica.SIunits.ComplexCurrent IAB2 = 1 / 3 * (IAB + IBC_2 + ICA_2)"symmetrical component of delta current";
  parameter Modelica.SIunits.Current IAB2_abs = (IAB2.re ^ 2 + IAB2.im ^ 2) ^ 0.5"absolute value of symmetrical component of delta current";
  parameter Real IAB2_arg(unit = "degree") = atan(IAB2.im / IAB2.re) * R2D "angle of symmetrical component of delta current";
  parameter Real IAB2_arg1(unit = "degree") = IAB2_arg + 180"modified angle of symmetrical component of delta current";
  parameter Modelica.SIunits.ComplexCurrent IAB0 = 1 / 3 * (IAB + IBC + ICA)"symmetrical component of delta current";
  parameter Modelica.SIunits.Current IAB0_real = IAB0.re"symmetrical component of delta current";
  //The answers may slightly vary due to rounding off values.
end Ex10_1;
