model Ex10_4

OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 25, V_b = 11, Vn = 11, ra = 0.001, x1d = 0.06) annotation(
    Placement(visible = true, transformation(origin = {-90, 4.44089e-16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor1(D = 0, M = 8, Sn = 15, V_b = 11, Vn = 11, ra = 0.001, x1d = 0.082) annotation(
    Placement(visible = true, transformation(origin = {192, 20}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor2(D = 0, M = 8, Sn = 7.5, V_b = 11, Vn = 11, ra = 0.001, x1d = 0.164) annotation(
    Placement(visible = true, transformation(origin = {192, -20}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 300) annotation(
    Placement(visible = true, transformation(origin = {26, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = 0.0805) annotation(
    Placement(visible = true, transformation(origin = {-54, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.0805) annotation(
    Placement(visible = true, transformation(origin = {88, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-16, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {120, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {62, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));

  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 25, fn = 50)  annotation(
    Placement(visible = true, transformation(origin = {-87, 65}, extent = {{-21, -21}, {21, 21}}, rotation = 0)));

parameter Real V(final quantity="ElectricPotential", final unit="kV")=123.2"transmission line voltage base";
parameter Modelica.SIunits.Reactance X=2.5"reactance of current limiting reactors in ohm";
parameter Real X1(unit = "pu")=(X*(SysData.S_b))/(motor2.V_b^2)"reactance of current limiting reactors";
parameter Real X2(unit = "pu")=3*X1"reactance of reactor included in zero sequence network";
parameter Real X_line(unit = "pu")=(pwLine1.X*SysData.S_b)/(V^2)"zero sequence reactance of transmission line";


equation
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-98, -10}, {-98, -10}, {-98, -18}, {-112, -18}, {-112, -4}, {-102, -4}, {-102, -4}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-98, 12}, {-98, 12}, {-98, 18}, {-112, 18}, {-112, 6}, {-102, 6}, {-102, 6}}, color = {0, 0, 127}));
  connect(motor2.pm, motor2.pm0) annotation(
    Line(points = {{204, -24}, {212, -24}, {212, -38}, {200, -38}, {200, -30}, {200, -30}}, color = {0, 0, 127}));
  connect(motor2.vf0, motor2.vf) annotation(
    Line(points = {{200, -8}, {200, -8}, {200, -2}, {212, -2}, {212, -14}, {204, -14}, {204, -14}}, color = {0, 0, 127}));
  connect(motor1.pm, motor1.pm0) annotation(
    Line(points = {{204, 16}, {212, 16}, {212, 2}, {200, 2}, {200, 10}, {200, 10}}, color = {0, 0, 127}));
  connect(motor1.vf0, motor1.vf) annotation(
    Line(points = {{200, 32}, {200, 32}, {200, 38}, {212, 38}, {212, 26}, {204, 26}, {204, 26}}, color = {0, 0, 127}));
  connect(bus2.p, motor2.p) annotation(
    Line(points = {{120, 0}, {120, -4}, {142, -4}, {142, -20}, {182, -20}}, color = {0, 0, 255}));
  connect(bus2.p, motor1.p) annotation(
    Line(points = {{120, 0}, {120, 4}, {142, 4}, {142, 20}, {182, 20}}, color = {0, 0, 255}));
  connect(bus3.p, twoWindingTransformer2.p) annotation(
    Line(points = {{62, 0}, {78, 0}, {78, 0}, {78, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus3.p) annotation(
    Line(points = {{36, 0}, {62, 0}, {62, 0}, {62, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, bus2.p) annotation(
    Line(points = {{99, 0}, {120, 0}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-16, 0}, {16, 0}, {16, 0}, {18, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-42, 0}, {-16, 0}, {-16, 0}, {-16, 0}}, color = {0, 0, 255}));
  connect(generator1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-80, 0}, {-65, 0}}, color = {0, 0, 255}));

annotation(
    Icon(coordinateSystem(extent = {{-140, -110}, {250, 110}})),
    Diagram(coordinateSystem(extent = {{-140, -110}, {250, 110}})),
    __OpenModelica_commandLineOptions = "");
end Ex10_4;
