model Ex11_2
parameter Real n=2"no.of generators";
parameter Real S_n(final quantity="Power", final unit="MVA")=20"system base power";
parameter Real v_b(final quantity="ElectricPotential", final unit="kV")=11"base voltage";
parameter Complex Xp=Complex(0,0.18)"positive sequence reactance in pu";
parameter Complex Xn=Complex(0,0.15)"negative sequence reactance in pu";
parameter Complex Xz=Complex(0,0.10)"zero sequence reactance in pu";
parameter Modelica.SIunits.Resistance R=2"earthing resistor";
parameter Real Ea(unit = "pu")=1"sequence voltage";
parameter Complex x1eq=(Xp/R)"positive sequence reactance of each generator in pu";
parameter Complex x2eq=(Xn/R)"negative sequence reactance of each generator in pu";
parameter Real Rn(unit = "pu")=(n*S_n)/(v_b)^2"earthing resistance";
parameter Complex Z0eq=(Xz+3*Rn)"zero sequence impedance in pu";
parameter Complex Ia=(3*(Ea/(x1eq+x2eq+Z0eq)))"fault current in kA";
parameter Real Ia_abs(final quantity="ElectricCurrent", final unit="kA") = (Ia.re ^ 2 + Ia.im ^ 2) ^ 0.5"absolute value of fault current";
parameter Real If_mod(final quantity="ElectricCurrent", final unit="kA")=Ia_abs*(20/(11*(3)^0.5))"current in the grounding resistors";
parameter Complex Vr=Rn*Ia"voltage across grounding resistor in complex form in kV";
parameter Real Vr_abs(final quantity="ElectricPotential", final unit="kV") = (Vr.re ^ 2 + Vr.im ^ 2) ^ 0.5"absolute value of voltage across grounding resistor";
parameter Real Vr_1(final quantity="ElectricPotential", final unit="kV")=Vr_abs*(11/(3)^0.5)"voltage across grounding resistor";
//The answers may slightly vary due to rounding off values.
end Ex11_2;
