model Ex11_3
OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = Sn1, V_b = 11, Vn = Vn1, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-145, -1}, extent = {{-9, -9}, {9, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor1(D = 0, M = 8, Sn = Sn2, V_b = 10, Vn = Vn2, ra = 0.001, x1d = X4.re) annotation(
    Placement(visible = true, transformation(origin = {129, 35}, extent = {{9, -9}, {-9, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.325) annotation(
    Placement(visible = true, transformation(origin = {-28, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1 annotation(
    Placement(visible = true, transformation(origin = {-98, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2 annotation(
    Placement(visible = true, transformation(origin = {48, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-66, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {10, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor2(D = 0, M = 8, Sn = Sn3, V_b = 10, Vn = 10, ra = 0.001, x1d = X5.re) annotation(
    Placement(visible = true, transformation(origin = {129, -39}, extent = {{9, -9}, {-9, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {90, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 5, t2 = 50) annotation(
    Placement(visible = true, transformation(origin = {70, -38}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  parameter Real Vn1(final quantity = "ElectricPotential", final unit = "kV") = 11 "generator base voltage";
  parameter Real Vn2(final quantity = "ElectricPotential", final unit = "kV") = 10 "motor base voltage";
  parameter Real Sn1(final quantity = "Power", final unit = "MVA") = 25 "generator base power";
  parameter Real Sn2(final quantity = "Power", final unit = "MW") = 15 "power that can be drawn by motor1";
  parameter Real Sn3(final quantity = "Power", final unit = "MW") = 7.5 "power that can be drawn by motor2";
  parameter Real pf = 0.8 "power factor";
  parameter Real Vf0(unit = "pu") = Vn2 / Vn1 "prefault voltage at g";
  constant Real pi = 2 * Modelica.Math.asin(1.0) "in radian";
  parameter Real R2D = 180 / pi "Radian to degree conversion";
  parameter Real D2R = pi / 180 "Degree to radian conversion";
  parameter Complex X1 = Complex(0, 0.2) "reactances calculated from equivalent Thevenin network of circuit shown in fig: 11.17 in pu";
  parameter Complex X2 = Complex(0, 0.23) "reactances calculated from equivalent Thevenin network of circuit shown in fig: 11.17 in pu";
  parameter Complex X3 = Complex(0, 0.325) "reactances calculated from equivalent Thevenin network of circuit shown in fig: 11.17 in pu";
  parameter Complex X4 = Complex(0, 0.345) "reactances calculated from equivalent Thevenin network of circuit shown in fig: 11.17 in pu";
  parameter Complex X5 = Complex(0, 0.69) "reactances calculated from equivalent Thevenin network of circuit shown in fig: 11.17 in pu";
  parameter Complex alfa = Complex(-0.5, 0.866) " value of exp(j120)";
  parameter Complex Z1 = (X1 + X3) * X2 / (X1 + X2 + X3) "thevenin equivalent impedance of circuit shown in fig: 11.17 in pu";
  parameter Complex Z2 = Z1 "thevenin equivalent impedance of circuit shown in fig: 11.17 in pu";
  parameter Complex Z0 = Complex(0, 1.712) "thevenin equivalent impedance of circuit shown in fig: 11.17 in pu";
  parameter Complex Ia1 = Vf0 / (Z1 + Z2 + Z0) "current obtained from the sequence network connection in pu";
  parameter Complex Ia2 = Ia1 "current obtained from the sequence network connection in pu";
  parameter Complex Ia0 = Ia1 "current obtained from the sequence network connection in pu";
  parameter Complex If = 3 * Ia0 "fault current in pu";
  parameter Complex Ia11 = Ia1 * (X2 / (X1 + X2 + X3)) "component of Ia1 flowing to g from generator in pu";
  parameter Complex Ia12 = Ia1 * ((X1 + X3) / (X1 + X2 + X3)) "component of Ia1 flowing to g from motor in pu";
  parameter Complex Ia21 = Ia11 "component of Ia2 flowing to g from generator in pu";
  parameter Complex Ia22 = Ia12 "component of Ia2 flowing to g from motor in pu";
  parameter Real Ia10(unit = "pu") = 0 "component of Ia1 flowing to g from motor2 in pu";
  parameter Complex Ia = Ia11 + Ia21 + Ia10 "fault currents from generator to g in pu";
  parameter Complex Ib = alfa ^ 2 * Ia11 + alfa * Ia21 + Ia10 "fault currents from generator to g in pu";
  parameter Complex Ic = alfa * Ia11 + alfa ^ 2 * Ia21 + Ia10 "fault currents from generator to g in pu";
  parameter Complex Ia_m = Ia12 + Ia22 + Ia0 "fault currents from motor to g in pu";
  parameter Complex Ib_m = alfa ^ 2 * Ia12 + alfa * Ia22 + Ia0 "fault currents from motor to g in pu";
  parameter Complex Ic_m = alfa * Ia12 + alfa ^ 2 * Ia22 + Ia0 "fault currents from motor to g in pu";
  parameter Complex I = Complex(0, -1) "positive sequence transmission line current componenet that is shifted -90 degree in pu";
  parameter Complex I_1 = Complex(0, 1) "negative sequence transmission line current componenet that is shifted +90 degree  in pu";
  parameter Complex Ip = I * Ia11 "positive sequence current in pu";
  parameter Complex In = I_1 * Ia11 "negative sequence current in pu";
  parameter Real Iz(unit = "pu") = 0 "zero sequence current";
  parameter Complex Il = Ip + In + Iz "line a current on the transmission line in pu";
  parameter Real M1_1(unit = "pu") = Sn2 / (Sn1 * Vf0 * pf) "voltages behind subtransient reactances";
  parameter Complex Im1 = Complex(M1_1 * cos(36.86 * D2R), M1_1 * sin(36.86 * D2R)) "motor1 current in pu";
  parameter Real Im1_abs(unit = "pu") = (Im1.re ^ 2 + Im1.im ^ 2) ^ 0.5 "absolute value of motor1 current";
  parameter Real Im1_arg(unit = "degree") = atan(Im1.im / Im1.re) * R2D "angle of motor1 current";
  parameter Real M2_1(unit = "pu") = Sn3 / (Sn1 * Vf0 * pf) "voltages behind subtransient reactances";
  parameter Complex Im2 = Complex(M2_1 * cos(36.86 * D2R), M2_1 * sin(36.86 * D2R)) "motor2 current in pu";
  parameter Real Im2_abs(unit = "pu") = (Im2.re ^ 2 + Im2.im ^ 2) ^ 0.5 "absolute value of motor2 current";
  parameter Real Im2_arg(unit = "degree") = atan(Im2.im / Im2.re) * R2D "angle of motor1 current";
  parameter Complex It = Im1 + Im2 "total current in pu";
  parameter Real It_abs(unit = "pu") = (It.re ^ 2 + It.im ^ 2) ^ 0.5 "absolute value of total current";
  parameter Real It_arg(unit = "degree") = atan(It.im / It.re) * R2D "angle of total current";
  parameter Complex Em1 = Vf0 - X4 * Im1 "voltages behind subtransient reactances of motor1 in pu";
  parameter Real Em1_abs(unit = "pu") = (Em1.re ^ 2 + Em1.im ^ 2) ^ 0.5 "absolute value of voltages behind subtransient reactances of motor1";
  parameter Real Em1_arg(unit = "degree") = atan(Em1.im / Em1.re) * R2D "angle of voltages behind subtransient reactances of motor1";
  parameter Complex Em2 = Vf0 - X5 * Im2 "voltages behind subtransient reactances of motor2 in pu";
  parameter Real Em2_abs(unit = "pu") = (Em2.re ^ 2 + Em2.im ^ 2) ^ 0.5 "absolute value of voltages behind subtransient reactances of motor2";
  parameter Real Em2_arg(unit = "degree") = atan(Em2.im / Em2.re) * R2D "angle of voltages behind subtransient reactances of motor2";
  parameter Complex Eg = Vf0 + (X1 + X3) * It "voltages behind subtransient reactances of generator in pu";
  parameter Real Eg_abs(unit = "pu") = (Eg.re ^ 2 + Eg.im ^ 2) ^ 0.5 "absolute value of voltages behind subtransient reactances of generator";
  parameter Real Eg_arg(unit = "degree") = atan(Eg.im / Eg.re) * R2D "angle of voltages behind subtransient reactances of generator";
  parameter Complex Ip_ac = It + Ia11 "actual value of positive sequence current from generator to fault in pu";
  parameter Complex In_ac = (-It) + Ia12 "actual value of negative sequence current from generator to fault in pu";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-159, 60}, extent = {{-21, -20}, {21, 20}}, rotation = 0)));
equation
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-156, -6}, {-166, -6}, {-166, -18}, {-152, -18}, {-152, -10}, {-152, -10}}, color = {0, 0, 127}));
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{-152, 8}, {-152, 8}, {-152, 18}, {-166, 18}, {-166, 4}, {-156, 4}, {-156, 4}}, color = {0, 0, 127}));
  connect(motor2.pm, motor2.pm0) annotation(
    Line(points = {{140, -44}, {150, -44}, {150, -56}, {136, -56}, {136, -48}, {136, -48}}, color = {0, 0, 127}));
  connect(motor2.vf0, motor2.vf) annotation(
    Line(points = {{136, -30}, {136, -30}, {136, -22}, {150, -22}, {150, -34}, {140, -34}, {140, -34}}, color = {0, 0, 127}));
  connect(motor1.pm0, motor1.pm) annotation(
    Line(points = {{136, 26}, {136, 26}, {136, 18}, {150, 18}, {150, 30}, {140, 30}, {140, 30}}, color = {0, 0, 127}));
  connect(motor1.vf0, motor1.vf) annotation(
    Line(points = {{136, 44}, {136, 44}, {136, 52}, {150, 52}, {150, 40}, {140, 40}, {140, 40}}, color = {0, 0, 127}));
  connect(bus3.p, pwFault1.p) annotation(
    Line(points = {{90, 0}, {90, 0}, {90, -8}, {70, -8}, {70, -30}, {70, -30}}, color = {0, 0, 255}));
  connect(bus3.p, motor2.p) annotation(
    Line(points = {{90, 0}, {90, 0}, {90, -4}, {108, -4}, {108, -40}, {120, -40}, {120, -38}}, color = {0, 0, 255}));
  connect(bus3.p, motor1.p) annotation(
    Line(points = {{90, 0}, {90, 0}, {90, 6}, {108, 6}, {108, 34}, {120, 34}, {120, 36}}, color = {0, 0, 255}));
  connect(bus2.p, twoWindingTransformer2.p) annotation(
    Line(points = {{10, 0}, {37, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, bus3.p) annotation(
    Line(points = {{59, 0}, {90, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{-19, 0}, {10, 0}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-66, 0}, {-37, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-87, 0}, {-66, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, order21.p) annotation(
    Line(points = {{-108, 0}, {-136, 0}, {-136, 0}, {-136, 0}}, color = {0, 0, 255}));
//The answers may slightly vary due to rounding off values.
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex11_3;
