model Ex11_5
parameter Complex Z1eq=Complex(0,0.09)"positive sequence impedance of each generator in pu obtained from Ex11_2";
parameter Complex Z2eq=Complex(0,0.075)"negative sequence impedance of each generator in pu obtained from Ex11_2";
parameter Complex Z0eq=Complex(0,0.1)"zero sequence impedance in pu";
parameter Real Zf(unit = "pu")=0"solid fault";
parameter Real Ea(unit = "pu")=1"sequence voltage";
parameter Complex alfa=Complex(-0.5,0.866)" value of exp(j120)";
constant Real pi = 2 * Modelica.Math.asin(1.0)"in radian";
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Complex Ia1=Ea/(Z1eq+((Z2eq*Z0eq)/(Z2eq+Z0eq)))"symmetrical component of fault current in phase a in pu";
parameter Complex Va1=Ea-(Ia1*Z1eq)"symmetrical component of voltage under fault in pu";
parameter Complex Va2=Va1"symmetrical component of voltage under fault in pu";
parameter Complex Va0=Va2"symmetrical component of voltage under fault in pu";
parameter Complex Ia2=-(Va2/Z2eq)"symmetrical component of fault current in phase a in pu";
parameter Complex Ia0=-(Va0/Z0eq)"symmetrical component of fault current in phase a in pu";
parameter Complex Ib=(((alfa^2)*Ia1)+(alfa*Ia2)+Ia0)"fault current in phase b in pu";
parameter Real Ib_abs(unit = "pu") = (Ib.re ^ 2 + Ib.im ^ 2) ^ 0.5"absolute value of fault current in phase b";
parameter Real Ib_arg(unit = "degree") = atan(Ib.im / Ib.re) * R2D "angle of fault current in phase b";
parameter Real Ib_arg1(unit = "degree") = Ib_arg + 180"modified angle of fault current in phase b";
parameter Complex Ic=(((alfa^2)*Ia2)+(alfa*Ia1)+Ia0)"fault current in phase c in pu";
parameter Real Ic_abs(unit = "pu") = (Ic.re ^ 2 + Ic.im ^ 2) ^ 0.5"absolute value of fault current in phase c";
parameter Real Ic_arg(unit = "degree") = atan(Ic.im / Ic.re) * R2D "angle of fault current in phase c";
parameter Complex Va=3*Va1"voltage of healthy phase for a double line-to-ground fault on terminals of generator in pu";
//The answers may slightly vary due to rounding off values.
end Ex11_5;
