model Ex11_6
OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 25, V_b = 11, Vn = 11, ra = 0.001, x1d = X1.im) annotation(
    Placement(visible = true, transformation(origin = {-141, -1}, extent = {{-11, -11}, {11, 11}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor1(D = 0, M = 8, Sn = 15, V_b = 11, Vn = 11, ra = 0.001, x1d = X4.im) annotation(
    Placement(visible = true, transformation(origin = {112, 24}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor2(D = 0, M = 8, Sn = 7.5, V_b = 11, Vn = 11, ra = 0.001, x1d = X5.im) annotation(
    Placement(visible = true, transformation(origin = {112, -26}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = X3.im) annotation(
    Placement(visible = true, transformation(origin = {-50, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = X2.im) annotation(
    Placement(visible = true, transformation(origin = {-104, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.0805) annotation(
    Placement(visible = true, transformation(origin = {8, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-158, 70}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
 OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-78, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-20, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));

parameter Real modv(unit = "pu")=1"prefault voltage";
parameter Complex X1=Complex(0,0.2)"positive and negative sequence reactance of generator";
parameter Complex X2=Complex(0,0.0805)"reactance of each transformer";
parameter Complex X3=Complex(0,0.164)"positive and negative sequence reactance of powerline";
parameter Complex X4=Complex(0,0.345)"positive and negative sequence reactance of motor1";
parameter Complex X5=Complex(0,0.69)"positive and negative sequence reactance of motor2";
parameter Complex X6=Complex(0,0)"zero valued reactance";
//According to problem values taken from Ex_10.4
parameter Complex X7=Complex(0,1.548)"reactance of reactor";
parameter Complex X8=Complex(0,0.06)"zero sequence reactance of generator";
parameter Complex X9=Complex(0,0.494)"zero sequence reactance of pw line";
parameter Complex Y1_dd=(1/X1)+(1/X2)"element of positive sequence bus admittance matrix";
parameter Complex Y1_fg=-1/X2"element of positive sequence bus admittance matrix";
parameter Complex Y1_ff=(1/X2)+(1/X3)"element of positive sequence bus admittance matrix";
parameter Complex Y1_ef=-1/X3"element of positive sequence bus admittance matrix";
parameter Complex Y1_gg=(1/X2)+(1/X4)+(1/X5)"element of positive sequence bus admittance matrix";
Complex [4,4]Y1_bus={{Y1_dd,Y1_fg,X6,X6},{Y1_fg,Y1_ff,Y1_ef,X6},{X6,Y1_ef,Y1_ff,Y1_fg},{X6,X6,Y1_fg,Y1_gg}}"positive sequence bus admittance matrix" ;
 Complex[4,4] Y2_bus=Y1_bus"negative sequence bus admittance matrix";
parameter Complex Y0_dd=1/(X7+X8)"element of zero sequence bus admittance matrix";
parameter Complex Y0_ee=(1/X2)+(1/X9)"element of zero sequence bus admittance matrix";
parameter Complex Y0_gg=1/(X7+X3)"element of zero sequence bus admittance matrix"; 
parameter Complex Y0_de=X6"element of zero sequence bus admittance matrix"; 
parameter Complex Y0_ef=-1/X9"element of zero sequence bus admittance matrix"; 
parameter Complex Y0_fg=X6"element of zero sequence bus admittance matrix"; 
Complex [4,4]Y0_bus={{Y0_dd,X6,X6,X6},{X6,Y0_ee,Y0_ef,X6},{X6,Y0_ef,Y0_ee,X6},{X6,X6,X6,Y0_gg}}"zero sequence bus admittance matrix" ;
//Inverting Y1_bus and Y0_bus we get Z1_bus and Z0_bus respectively and they are as follows
parameter Real [4,4]Z1_bus={{0.14706,0.12575,0.08233,0.06102},{0.12575,0.17636,0.11547,0.08558},{0.08233,0.11547,0.18299,0.13563},{0.06102,0.08558,0.13563,0.16019}}"positive sequence bus impedance matrix in real form" ;
parameter Complex [4,4]Z1_bus_new=Complex(0,Z1_bus)"positive sequence bus impedance matrix";
parameter Complex [4,4]Z2_bus_new=Z1_bus_new"negative sequence bus impedance matrix";
parameter Real [4,4]Z0_bus={{0.61031,0,0,0},{0,0.07061,0.00989,0},{0,0.00989,0.07061,0},{0,0,0,1.71233}}"zero sequence bus impedance matrix in real form" ;
parameter Complex [4,4]Z0_bus_new=Complex(0,Z0_bus)"zero sequence bus impedance matrix" ;
parameter Complex Ie_f=3*modv/(Z1_bus_new[2,2]+Z1_bus_new[2,2]+Z0_bus_new[2,2])"fault current with LG fault on bus e in pu";
parameter Complex If_f=3*modv/(Z1_bus_new[3,3]+Z1_bus_new[3,3]+Z0_bus_new[2,2])"fault current with LG fault on bus f in pu";
parameter Complex Vf_1d=modv-Z1_bus_new[1,2]*(Ie_f/3)"postfault positive sequence voltage at bus d in pu";
parameter Complex Vf_1f=modv-Z1_bus_new[2,3]*(Ie_f/3)"postfault positive sequence voltage at bus f in pu";
parameter Complex Vf_1e=modv-Z1_bus_new[2,2]*(Ie_f/3)"postfault positive sequence voltage at bus e in pu";
parameter Complex Vf_1g=modv-Z1_bus_new[2,4]*(Ie_f/3)"postfault positive sequence voltage at bus g in pu";
parameter Complex Vf_2f=-Z2_bus_new[2,3]*(Ie_f/3)"postfault negative sequence voltage at bus f in pu";
parameter Complex Vf_0f=-Z0_bus_new[2,3]*(Ie_f/3)"postfault zero sequence voltage at bus f in pu";
parameter Complex Vf_2e=-Z2_bus_new[2,2]*(Ie_f/3)"postfault negative sequence voltage at bus e in pu";
parameter Complex Vf_0e=-Z0_bus_new[2,2]*(Ie_f/3)"postfault zero sequence voltage at bus e in pu";
parameter Complex Vf_2g=-Z2_bus_new[4,2]*(Ie_f/3)"postfault negative sequence voltage at bus g in pu";
parameter Complex Vf_0g=-Z0_bus_new[4,2]*(Ie_f/3)"postfault zero sequence voltage at bus g in pu";
parameter Complex If1_fe=-Y1_ef*(Vf_1f-Vf_1e)"postfault positive sequence current for line fe";
parameter Complex If1_de=-Y1_fg*(Vf_1d-Vf_1e)"postfault positive sequence current for line de";
parameter Complex Ia1=If1_fe+If1_de"symmetrical componenet of fault current";
parameter Complex If1_gf=Y1_fg*(Vf_1g-Vf_1f)"postfault positive sequence current for line gf";
parameter Complex If2_fe=-Y1_ef*(Vf_2f-Vf_2e)"postfault negative sequence current for line fe";
parameter Complex If0_fe=-Y0_ef*(Vf_0f-Vf_0e)"postfault zero sequence current for line fe";
parameter Complex  If_fe_a=-If1_gf+If2_fe+If0_fe"current in line fe";
 equation
  connect(bus2.p, twoWindingTransformer2.p) annotation(
    Line(points = {{-20, 0}, {-4, 0}, {-4, 0}, {-2, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{-40, 0}, {-20, 0}, {-20, 0}, {-20, 0}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-78, 0}, {-60, 0}, {-60, 0}, {-58, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-92, 0}, {-78, 0}, {-78, 0}, {-78, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, generator1.p) annotation(
    Line(points = {{-115, 0}, {-130, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, motor1.p) annotation(
    Line(points = {{19, 0}, {19, 24}, {102, 24}}, color = {0, 0, 255}));
  connect(motor1.vf0, motor1.vf) annotation(
    Line(points = {{120, 35}, {120, 35}, {120, 43}, {138, 43}, {138, 27}, {124, 27}, {124, 29}}, color = {0, 0, 127}));
  connect(motor1.pm, motor1.pm0) annotation(
    Line(points = {{124, 19}, {138, 19}, {138, 3}, {120, 3}, {120, 13}, {120, 13}}, color = {0, 0, 127}));
  connect(motor2.pm, motor2.pm0) annotation(
    Line(points = {{124, -30}, {138, -30}, {138, -44}, {120, -44}, {120, -36}, {120, -36}}, color = {0, 0, 127}));
  connect(motor2.vf0, motor2.vf) annotation(
    Line(points = {{120, -14}, {120, -14}, {120, -8}, {138, -8}, {138, -22}, {124, -22}, {124, -20}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-150, 12}, {-150, 12}, {-150, 20}, {-170, 20}, {-170, 4}, {-154, 4}, {-154, 4}}, color = {0, 0, 127}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-154.2, -6.5}, {-169.8, -6.5}, {-169.8, -20}, {-151.8, -20}, {-151.8, -13}, {-150.2, -13}}, color = {0, 0, 127}));
  connect(twoWindingTransformer2.n, motor2.p) annotation(
    Line(points = {{20, 0}, {20, 0}, {20, -26}, {102, -26}, {102, -26}}, color = {0, 0, 255}));
annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex11_6;
