model Ex11_7
OpenIPSL.Electrical.Machines.PSAT.Order2 generator(D = 0, M = 8,Sn = 1.2, V_b = 0.6, Vn = 0.6, ra = 0, x1d = Xg)  annotation(
    Placement(visible = true, transformation(origin = {-142, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor(D = 0, M = 8, Sn = 1.2, V_b = 0.6, Vn = 0.6, ra = 0, x1d = Xm)  annotation(
    Placement(visible = true, transformation(origin = {140, 0}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = Xt1)  annotation(
    Placement(visible = true, transformation(origin = {-90, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = Xt2)  annotation(
    Placement(visible = true, transformation(origin = {94, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = Xl)  annotation(
    Placement(visible = true, transformation(origin = {-4, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-50, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {48, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 5, t2 = 50)  annotation(
    Placement(visible = true, transformation(origin = {-34, -32}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  constant Real pi = 2 * Modelica.Math.asin(1.0)"in radian";
  parameter Real R2D = 180 / pi"Radian to degree conversion";
  parameter Real D2R = pi / 180"Degree to radian conversion";
  parameter Complex a = Complex(1 * cos(120*D2R), 1 * sin(120*D2R))"value of exp(j*120)";
  parameter Complex b = Complex(1 * cos(240*D2R), 1 * sin(240*D2R))"value of exp(j*240)";
  parameter Real a_abs = (a.re ^ 2 + a.im ^ 2) ^ 0.5"absolute value of a";
  parameter Real a_arg(unit = "degree") = atan(a.im / a.re) * R2D "angle of a";
  parameter Real a_arg1(unit = "degree") =a_arg+180"modified angle of a";
  parameter Real b_abs = (b.re ^ 2 + b.im ^ 2) ^ 0.5"absolute value of b";
  parameter Real b_arg(unit = "degree") = atan(b.im / b.re) * R2D "angle of b";
  parameter Real b_arg1(unit = "degree") =b_arg+180"modified angle of b";
  parameter Real V1_0(unit = "pu")=1"system unloaded voltage before fault";
  //case a: for passive positive and negative sequence network
  parameter Real Xg(unit = "pu")=0.1"reactance of generator";
  parameter Real Xm(unit = "pu")=0.1"reactance of motor";
  parameter Real Xt1(unit = "pu")=0.05"reactance of transformer 1";
  parameter Real Xt2(unit = "pu")=0.05"reactance of transformer 2";
  parameter Real Xl(unit = "pu")=0.2"reactance of line";
  parameter Real X1(unit = "pu")=Xg+Xt1"total reactance of generator and transformer";
  parameter Real X2(unit = "pu")=Xg+Xt1+Xl"total reactance of generator, transformer and line";
  parameter Real [2,2]Z_1_bus(unit = "pu")={{X1,X1},{X1,X2}}"bus impedance matrix from Bus 2 to Bus 1";
  parameter Complex [2,2]Z1_bus= Complex(0,Z_1_bus)"bus impedance matrix from Bus 2 to Bus 1 in complex form";
  parameter Real [2,1]Z_1_abus(unit = "pu")={{X1},{X2}}"bus impedance matrix from Bus 2 to referance bus";
  parameter Real [1,2]Z_1_bbus(unit = "pu")=transpose(Z_1_abus)"transpose of bus impedance matrix from Bus 2 to referance bus";
  parameter Real [2,2]Z_1_cbus(unit = "pu")=Z_1_abus*Z_1_bbus"product of bus impedance matrix from Bus 2 to referance bus and its transpose";  
  parameter Real [2,2]Z_1_bus_new(unit = "pu")=Z_1_bus-(1/(X2+X1))*Z_1_cbus"positive sequence bus impedance matrix";
  parameter Complex [2,2]Z1_bus_new1= Complex(0,Z_1_bus_new)"positive sequence bus impedance matrix in complex form";
  parameter Complex [2,2]Z2_bus_new1=Z1_bus_new1"negative sequence bus impedance matrix";
  //case b: for zero sequence network
  parameter Real Xl2(unit = "pu")=0.4"reactance of line for zero sequence network";
  parameter Real X3(unit = "pu")=Xl2+Xt1"total reactance of line and transformer";
  parameter Real [2,2]Z_0_bus(unit = "pu")={{Xt1,Xt1},{Xt1,X3}}"zero sequence bus impedance matrix from Bus 2 to Bus 1";
  parameter Complex [2,2]Z0_bus= Complex(0,Z_0_bus)"zero sequence bus impedance matrix in complex form from Bus 2 to Bus 1";
  parameter Real [2,1]Z_0_abus(unit = "pu")={{Xt1},{X3}}"bus impedance matrix";
  parameter Real [1,2]Z_0_bbus(unit = "pu")=transpose(Z_0_abus)"transpose of bus impedance matrix";
  parameter Real [2,2]Z_0_cbus(unit = "pu")=Z_0_abus*Z_0_bbus"product of bus impedance matrix and its transpose";
  parameter Real [2,2]Z_0_bus_new(unit = "pu")=Z_0_bus-(1/(X3+Xt1))*Z_0_cbus"zero sequence bus impedance matrix from Bus 2 to referance bus";
  parameter Complex [2,2]Z0_bus_new1= Complex(0,Z_0_bus_new)"zero sequence bus impedance matrix from Bus 2 to referance bus in complex form";  
  parameter Complex V=Complex(0,V1_0)"system unloaded voltage before fault in complex form";
  parameter Complex If1_1=-V/(Z1_bus_new1[1,1].im+Z2_bus_new1[1,1].im+Z0_bus_new1[1,1].im)"positive sequence current in pu";
  parameter Complex If2_1=If1_1"negative sequence current in pu";
  parameter Complex If0_1=If1_1"zero sequence current in pu";
  //solution of a
  parameter Complex If=3*If1_1"fault current in pu";
  // solution of b
  parameter Complex Vf1_1=V1_0-If1_1*Z1_bus_new1[1,1]"post fault positive sequence voltage at bus1 in pu";
  parameter Complex Vf1_2=V1_0-If2_1*Z1_bus_new1[2,1]"post fault positive sequence voltage at bus2 in pu";
  parameter Complex Vf2_1=-If2_1*Z2_bus_new1[1,1]"post fault negative sequence voltage at bus1 in pu";
  parameter Complex Vf2_2=-If2_1*Z2_bus_new1[2,1]"post fault negative sequence voltage at bus2 in pu";
  parameter Complex Vf0_1=-If0_1*Z0_bus_new1[1,1]"post fault zero sequence voltage at bus1 in pu";
  parameter Complex Vf0_2=-If0_1*Z0_bus_new1[2,1]"post fault zero sequence voltage at bus2 in pu";
  parameter Complex y1_12=Complex(0,Xl)"positive sequence admittance in the line12 ";
  parameter Complex y2_12=y1_12"negative sequence admittance in the line12 ";
  parameter Complex y0_12=Complex(0,Xl2)"zero sequence admittance in the line12 ";
  parameter Complex If1_12=(1/y1_12)*(Vf1_1-Vf1_2)"positive sequence current in the line12 in pu";
  parameter Complex If2_12=(1/y2_12)*(Vf2_1-Vf2_2)"negative sequence current in the line12 in pu";
  parameter Complex If0_12=(1/y0_12)*(Vf0_1-Vf0_2)"zero sequence current in the line12 in pu";
  parameter Complex Ifa_12=If1_12+If2_12+If0_12"SC current on the transmission line in phase a";
  parameter Complex Ifb_12=b*If1_12+a*If2_12+If0_12"SC current on the transmission line in phase b";
  parameter Complex Ifc_12=a*If1_12+b*If2_12+If0_12"SC current on the transmission line in phase c";
  //Solution of c
  parameter Complex c1 = Complex(1 * cos(-30*D2R), 1 * sin(-30*D2R))"value of exp(j*-30)";
  parameter Complex c2 = Complex(1 * cos(30*D2R), 1 * sin(30*D2R))"value of exp(j*30)";
  parameter Complex y1_g=Complex(0,X1)"positive sequence admittance of the generator";
  parameter Complex If1_g =(1/y1_g)*(1-Vf1_1)*c1"positive sequence current of the generator";
  parameter Complex If2_g =(1/y1_g)*(Vf2_1)*c2"negative sequence current of the generator";
  parameter Real If0_g(unit = "pu") =0"zero sequence current of the generator";
  parameter Complex Ifa_g =If1_g+If2_g+If0_g"SC current in phase a of the generator";
  //solution of d
  parameter Complex Vfb_1=Vf1_1*b+Vf2_1*a+Vf2_2"voltage of the healthy phase b of the bus1";
  parameter Real Vfb_1_abs(unit = "pu") = (Vfb_1.re ^ 2 + Vfb_1.im ^ 2) ^ 0.5"absolute value of voltage of the healthy phase b of the bus1";
  parameter Real Vfb_1_arg(unit = "degree") = atan(Vfb_1.im / Vfb_1.re) * R2D "angle of voltage of the healthy phase b of the bus1";
  parameter Real Vfb_1_arg1(unit = "degree") =Vfb_1_arg-180"modified angle of voltage of the healthy phase b of the bus1";
  parameter Complex Vfc_1=Vf1_1*a+Vf2_1*b+Vf2_2"voltage of the healthy phase c of the bus1";
  parameter Real Vfc_1_abs(unit = "pu") = (Vfc_1.re ^ 2 + Vfc_1.im ^ 2) ^ 0.5"absolute value of voltage of the healthy phase c of the bus1";
  parameter Real Vfc_1_arg(unit = "degree") = atan(Vfc_1.im / Vfc_1.re) * R2D "angle of voltage of the healthy phase c of the bus1";
  parameter Real Vfc_1_arg1(unit = "degree") =Vfc_1_arg+180"modified angle of voltage of the healthy phase c of the bus1";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-166, 71}, extent = {{-20, -17}, {20, 17}}, rotation = 0)));
equation
  connect(bus1.p, pwFault1.p) annotation(
    Line(points = {{-50, 0}, {-50, 0}, {-50, -6}, {-34, -6}, {-34, -24}, {-34, -24}}, color = {0, 0, 255}));
  connect(motor.vf, motor.vf0) annotation(
    Line(points = {{152, -4}, {162, -4}, {162, -18}, {148, -18}, {148, -10}, {148, -10}}, color = {0, 0, 127}));
  connect(generator.pm0, generator.pm) annotation(
    Line(points = {{-150, -10}, {-150, -10}, {-150, -18}, {-164, -18}, {-164, -6}, {-154, -6}, {-154, -4}}, color = {0, 0, 127}));
  connect(generator.vf0, generator.vf) annotation(
    Line(points = {{-150, 12}, {-150, 12}, {-150, 20}, {-164, 20}, {-164, 6}, {-154, 6}, {-154, 6}}, color = {0, 0, 127}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{5, 0}, {48, 0}}, color = {0, 0, 255}));
  connect(bus2.p, twoWindingTransformer2.p) annotation(
    Line(points = {{48, 0}, {83, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, motor.p) annotation(
    Line(points = {{105, 0}, {130, 0}}, color = {0, 0, 255}));
  connect(motor.pm, motor.pm0) annotation(
    Line(points = {{152, 5}, {162, 5}, {162, 19}, {148, 19}, {148, 11}, {148, 11}}, color = {0, 0, 127}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-50, 0}, {-13, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-79, 0}, {-50, 0}}, color = {0, 0, 255}));
  connect(generator.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-132, 0}, {-101, 0}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex11_7;
