model Ex12_2a
OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 100, Vn = 480, ra = 0.001, x1d = Xg) annotation(
    Placement(visible = true, transformation(origin = {-154, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-82, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = Xp) annotation(
    Placement(visible = true, transformation(origin = {-38, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {8, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Banks.PwShuntC pwShuntC1(Qnom = 1, Vbase = 400) annotation(
    Placement(visible = true, transformation(origin = {20, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = Xt1) annotation(
    Placement(visible = true, transformation(origin = {-116, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = Xt2) annotation(
    Placement(visible = true, transformation(origin = {78, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor1(D = 0, M = 8, Sn = 100, Vn = 400, ra = 0.001, x1d = Xm) annotation(
    Placement(visible = true, transformation(origin = {146, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  parameter Real Eg(unit = "pu") = 1.2 "internal voltage of generator";
  parameter Real Em(unit = "pu") = 1 "internal voltage of motor";
  parameter Real Xg(unit = "pu") = 1 "reactance of generator";
  parameter Real Xt1(unit = "pu") = 0.1 "reactance of transformer1";
  parameter Real Xt2(unit = "pu") = 0.1 "reactance of transformer2";
  parameter Real Xp(unit = "pu") = 0.25 "reactance of pw line";
  parameter Real Xm(unit = "pu") = 1 "reactance of motor";
  parameter Real Xtotal(unit = "pu") = Xg + Xt1 + Xt2 + Xp + Xm "total reactance";
  parameter Real Powerlimit(unit = "pu") = Eg * Em / Xtotal "steady state power limit without reactor";
  parameter Real Xc(unit = "pu") = -1 "reactance of capacitor";
  parameter Real X1(unit = "pu") = Xg + Xt1 + Xp"equivalent reactance calculated after converting the network from star to delta";
  parameter Real X2(unit = "pu") = Xm + Xt2"equivalent reactance calculated after converting the network from star to delta";
  parameter Real X3(unit = "pu") = X1 * X2"equivalent reactance calculated after converting the network from star to delta";
  parameter Real X4(unit = "pu") = Xm + Xt2"equivalent reactance calculated after converting the network from star to delta";
  parameter Real X5(unit = "pu") = X4 * Xc"equivalent reactance calculated after converting the network from star to delta";
  parameter Real X6(unit = "pu") = Xc * X1"equivalent reactance calculated after converting the network from star to delta";
  parameter Real X(unit = "pu") = (X3 + X5 + X6) / Xc"transfer reactance calculated after converting the network from star to delta";
  parameter Real SSpowerlimit(unit = "pu") = Eg * Em / X "steady state power limit with capacitive reactor";
  //The answers may slightly vary due to rounding off values.   

  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-161, 72}, extent = {{-19, -18}, {19, 18}}, rotation = 0)));
equation
  connect(motor1.pm, motor1.pm0) annotation(
    Line(points = {{158, -4}, {164, -4}, {164, -16}, {154, -16}, {154, -10}, {154, -10}}, color = {0, 0, 127}));
  connect(motor1.vf0, motor1.vf) annotation(
    Line(points = {{154, 12}, {154, 12}, {154, 18}, {164, 18}, {164, 6}, {158, 6}, {158, 6}}, color = {0, 0, 127}));
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-162, -10}, {-162, -10}, {-162, -16}, {-174, -16}, {-174, -6}, {-166, -6}, {-166, -4}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-162, 12}, {-162, 12}, {-162, 18}, {-174, 18}, {-174, 6}, {-166, 6}, {-166, 6}}, color = {0, 0, 127}));
  connect(bus2.p, pwShuntC1.p) annotation(
    Line(points = {{8, 0}, {8, 0}, {8, -6}, {20, -6}, {20, -40}, {20, -40}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.p, bus2.p) annotation(
    Line(points = {{67, 0}, {8, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, motor1.p) annotation(
    Line(points = {{89, 0}, {136, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus2.p) annotation(
    Line(points = {{-29, 0}, {8, 0}}, color = {0, 0, 255}));
  connect(pwLine2.p, bus1.p) annotation(
    Line(points = {{-47, 0}, {-82, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-105, 0}, {-82, 0}}, color = {0, 0, 255}));
  connect(generator1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-144, 0}, {-127, 0}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex12_2a;
