model Ex12_2b
OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 100, Vn = 480, ra = 0.001, x1d = 1) annotation(
    Placement(visible = true, transformation(origin = {-142, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-54, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.25) annotation(
    Placement(visible = true, transformation(origin = {-4, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {42, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Banks.PwShuntR pwShuntR1(Qnom = 1, Vbase = 400) annotation(
    Placement(visible = true, transformation(origin = {64, -34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-165, 76}, extent = {{-23, -18}, {23, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-92, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {88, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22(D = 0, M = 8, Sn = 100, Vn = 400, ra = 0.001, x1d = 1) annotation(
    Placement(visible = true, transformation(origin = {140, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  parameter Real Eg(unit = "pu") = 1.2 "internal voltage of generator";
  parameter Real Em(unit = "pu") = 1 "internal voltage of motor";
  parameter Real Xg(unit = "pu") = 1 "reactance of generator";
  parameter Real Xt1(unit = "pu") = 0.1 "reactance of transformer1";
  parameter Real Xt2(unit = "pu") = 0.1 "reactance of transformer2";
  parameter Real Xp(unit = "pu") = 0.25 "reactance of pw line";
  parameter Real Xm(unit = "pu") = 1 "reactance of motor";
  parameter Real Xtotal(unit = "pu") = Xg + Xt1 + Xt2 + Xp + Xm "total reactance";
  parameter Real Xc(unit = "pu") = 1 "reactance of inductor";
  parameter Real X1(unit = "pu") = Xg + Xt1 + Xp"equivalent reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real X2(unit = "pu") = Xm + Xt2"equivalent reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real X3(unit = "pu") = X1 * X2"equivalent reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real X4(unit = "pu") = Xm + Xt2"equivalent reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real X5(unit = "pu") = X4 * Xc"equivalent reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real X6(unit = "pu") = Xc * X1"equivalent reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real X(unit = "pu") = (X3 + X5 + X6) / Xc"transfer reactance calculated after converting the network from star to delta, with capacitive reactor replaced by inductive reactance";
  parameter Real SSpowerlimit(unit = "pu") = Eg * Em / X "steady state power limit with inductive reactor";
  //The answers may slightly vary due to rounding off values.   

equation
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{152, -4}, {162, -4}, {162, -18}, {148, -18}, {148, -10}, {148, -10}}, color = {0, 0, 127}));
  connect(order22.vf0, order22.vf) annotation(
    Line(points = {{148, 12}, {148, 12}, {148, 20}, {162, 20}, {162, 6}, {152, 6}, {152, 6}}, color = {0, 0, 127}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-150, -10}, {-150, -10}, {-150, -20}, {-164, -20}, {-164, -6}, {-154, -6}, {-154, -4}}, color = {0, 0, 127}));
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{-150, 12}, {-150, 12}, {-150, 20}, {-164, 20}, {-164, 6}, {-154, 6}, {-154, 6}}, color = {0, 0, 127}));
  connect(bus2.p, pwShuntR1.p) annotation(
    Line(points = {{42, 0}, {42, 0}, {42, -6}, {64, -6}, {64, -24}, {64, -24}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus2.p) annotation(
    Line(points = {{5, 0}, {42, 0}}, color = {0, 0, 255}));
  connect(pwLine2.p, bus1.p) annotation(
    Line(points = {{-13, 0}, {-54, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-81, 0}, {-54, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.p, bus2.p) annotation(
    Line(points = {{77, 0}, {42, 0}}, color = {0, 0, 255}));
  connect(order21.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-132, 0}, {-103, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, order22.p) annotation(
    Line(points = {{99, 0}, {130, 0}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex12_2b;
