model Ex12_4
inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-166, 67}, extent = {{-20, -19}, {20, 19}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {82, -1.11022e-15}, extent = {{-14, -14}, {14, 14}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1, angle_0 = 0) annotation(
    Placement(visible = true, transformation(origin = {160, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {8, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {6, -10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault Fault(R = 0, X = 0.01, t1 = 0.50, t2 = 0.55) annotation(
    Placement(visible = true, transformation(origin = {42, -42}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-64, 0}, extent = {{-14, -14}, {14, 14}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1 annotation(
    Placement(visible = true, transformation(origin = {-102, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.15) annotation(
    Placement(visible = true, transformation(origin = {122, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-32, -10}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {50, -10}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 Generator1(D = 0, M = 8, Sn = 100, Vn = 400, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-146, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
constant Real pi = 2 * Modelica.Math.asin(1.0);// 3.14159265358979 in radian;  
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion"; 
parameter Modelica.SIunits.Time t=0.05"time interval";
parameter Real H(final quantity="Inertia", final unit="MJ/MVA") = 4 "inertia constant of generator";
parameter Modelica.SIunits.Frequency f = 50 "frequency of generator";
parameter Real delta_0(unit = "degree")=33.9"initial rotor angle";
parameter Real delta_1(unit = "rad")=33.9*D2R"initial rotor angle";
parameter Real Pm(unit = "pu")=1"maximum power";
parameter Real Pe(unit = "pu")=0.694*sin(delta_1)"electrical power";
parameter Real a_initial(unit = "elect deg/s^2")=((180*f)/H)*(Pm-Pe)"initial angular acceleration";
parameter Real del_delta(unit = "degree")=0.5*a_initial*(t^2)"change in rotor angle";
parameter Real delta_new(unit = "degree")=delta_0+del_delta"rotor angle at the end of the time interval";
parameter Real delta_new1(unit = "rad")=delta_new*D2R"rotor angle at the end of the time interval";
parameter Real Pe1(unit = "pu")=0.694*sin(delta_new1)"modified electrical power";
parameter Real a_new(unit = "elect deg/s^2")=((180*f)/H)*(Pm-Pe1)"new angular acceleration";
//The answers may slightly vary due to rounding off values.   
equation
  connect(breaker1.s, bus1.p) annotation(
    Line(points = {{-37, -10}, {-64, -10}, {-64, 0}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine2.p) annotation(
    Line(points = {{-27, -10}, {-2, -10}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker2.s) annotation(
    Line(points = {{16, -10}, {45, -10}}, color = {0, 0, 255}));
  connect(breaker2.r, bus2.p) annotation(
    Line(points = {{55, -10}, {82, -10}, {82, 0}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine3.p) annotation(
    Line(points = {{82, 0}, {113, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{17, 12}, {82, 12}, {82, 0}}, color = {0, 0, 255}));
  connect(pwLine3.n, infiniteBus1.p) annotation(
    Line(points = {{131, 0}, {170, 0}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus1.p) annotation(
    Line(points = {{-1, 12}, {-64, 12}, {-64, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-91, 0}, {-64, 0}}, color = {0, 0, 255}));
  connect(Generator1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-136, 0}, {-113, 0}}, color = {0, 0, 255}));
  connect(Generator1.vf0, Generator1.vf) annotation(
    Line(points = {{-154, 11}, {-166, 11}, {-166, 3}, {-158, 3}, {-158, 5}}, color = {0, 0, 127}));
  connect(Generator1.pm0, Generator1.pm) annotation(
    Line(points = {{-154, -11}, {-166, -11}, {-166, -3}, {-158, -3}, {-158, -5}}, color = {0, 0, 127}));
  connect(Fault.p, pwLine2.n) annotation(
    Line(points = {{35, -42}, {20, -42}, {20, -10}, {15, -10}}, color = {0, 0, 255}));
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");


end Ex12_4;
